/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.extern.utils.apache_commons_configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;

public class ConfigCache {
    private static final Logger theLogger = Logger.getLogger(ConfigCache.class.getName());
    private Map<String, Configuration> myConfigs = new HashMap<String, Configuration>();

    public Configuration getLinkedConfig(Configuration config, String key) {
        if (this.myConfigs.containsKey(key)) {
            return this.myConfigs.get(key);
        }
        if (config == null || key == null) {
            return null;
        }
        String path = config.getString(key, null);
        if (path == null) {
            theLogger.log(Level.SEVERE, "Unable to find Configuratin key: {0}. Unable to retrieve specified Configuration.", key);
            return null;
        }
        PropertiesConfiguration keyConfig = null;
        try {
            File file = ConfigUtils.getFileSystemAdapter().openFile(path);
            keyConfig = new PropertiesConfiguration(file);
        }
        catch (ConfigurationException ex) {
            theLogger.log(Level.SEVERE, "Unable to open Configuration for key '" + key + "', at '" + path + "'.", ex);
        }
        if (keyConfig != null && !keyConfig.isEmpty()) {
            this.myConfigs.put(key, (Configuration)keyConfig);
        }
        return keyConfig;
    }
}

