/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.jflux.api.core.chain.ListenerChain;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.event.Event;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.DefaultConsumerNode;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.RKDependencyConfigUtils;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobot;
import org.robokind.api.motion.messaging.RemoteRobotHost;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.demo.robot.replication.ReplicationUtils;

public class RobotReplicator {
    private static final String theRobotHost = "robotHost";
    private static final String theRemoteRobot = "remoteRobot";
    public static final String REPLICATION_CONNECTION_CONFIG_ID = "robotReplicationConnectionConfig";
    public static final String RECEIVER_CONNECTION_CONFIG_ID = "robotReceiverConnectionConfig";
    public static final String DESTINATION_CONFIG_ID = "robotReplicationDestinationConfig";

    public static void startRobotReplicator(BundleContext context, String replicationGroupId, String connectionConfigId, String destConfigId, List<Joint> joints, long replicationPeriod, String[] propNames, ManagedServiceFactory fact) {
        ReplicationUtils.startReplicator(context, replicationGroupId, destConfigId, connectionConfigId, 2000L, replicationPeriod, fact);
        RobotReplicator.replicateJoints(replicationGroupId, replicationGroupId, joints, propNames, fact);
    }

    private static void replicateJoints(String replicationGroupId, String bufferRouteKeyPrefix, List<Joint> joints, String[] propNames, ManagedServiceFactory fact) {
        for (Joint joint : joints) {
            RobotReplicator.replicateJointProperties(replicationGroupId, bufferRouteKeyPrefix, joint, propNames, fact);
        }
    }

    private static void replicateJointProperties(String replicationGroupId, String bufferRouteKeyPrefix, Joint joint, String[] propNames, ManagedServiceFactory fact) {
        if (propNames == null) {
            for (JointProperty p : joint.getProperties()) {
                String bufferRouteKey = bufferRouteKeyPrefix + joint.getId().toString() + p.getPropertyName();
                RobotReplicator.addJointPropertyBuffer(replicationGroupId, bufferRouteKey, p, fact);
            }
            return;
        }
        for (String name : propNames) {
            JointProperty p = joint.getProperty(name);
            if (p == null) continue;
            String bufferRouteKey = bufferRouteKeyPrefix + joint.getId().toString() + name;
            RobotReplicator.addJointPropertyBuffer(replicationGroupId, bufferRouteKey, p, fact);
        }
    }

    private static void addJointPropertyBuffer(String replicationGroupId, String bufferRouteKey, JointProperty prop, ManagedServiceFactory fact) {
        Class<NormalizedDouble> messageClass = NormalizedDouble.class;
        JointPropertySource propSource = new JointPropertySource(prop);
        ReplicationUtils.createAlternateReplicationBuffer(replicationGroupId, bufferRouteKey, propSource, messageClass, fact);
    }

    public static void startRobotReceiver(String receiverGroupId, String connectionConfigId, String destConfigId, List<Joint> joints, String[] propNames, ManagedServiceFactory fact) {
        ReplicationUtils.startReceiver(receiverGroupId, destConfigId, connectionConfigId, fact);
        RobotReplicator.receiveJoints(receiverGroupId, receiverGroupId, joints, propNames, fact);
    }

    private static void receiveJoints(String receiverGroupId, String bufferRouteKeyPrefix, List<Joint> joints, String[] propNames, ManagedServiceFactory fact) {
        for (Joint joint : joints) {
            RobotReplicator.receiveJointProperties(receiverGroupId, bufferRouteKeyPrefix, joint, propNames, fact);
        }
    }

    private static void receiveJointProperties(String receiverGroupId, String bufferRouteKeyPrefix, Joint joint, String[] propNames, ManagedServiceFactory fact) {
        if (propNames == null) {
            for (JointProperty p : joint.getProperties()) {
                String bufferRouteKey = bufferRouteKeyPrefix + joint.getId().toString() + p.getPropertyName();
                RobotReplicator.addJointPropertyRoute(receiverGroupId, bufferRouteKey, p, fact);
            }
            return;
        }
        for (String name : propNames) {
            JointProperty p = joint.getProperty(name);
            if (p == null) continue;
            String bufferRouteKey = bufferRouteKeyPrefix + joint.getId().toString() + name;
            RobotReplicator.addJointPropertyRoute(receiverGroupId, bufferRouteKey, p, fact);
        }
    }

    private static void addJointPropertyRoute(String receiverGroupId, String bufferRouteKey, JointProperty prop, ManagedServiceFactory fact) {
        String consumerIdKey = "jointPropRoute";
        String consumerId = bufferRouteKey;
        RobotReplicator.launchJointPropConsumer(consumerIdKey, consumerId, prop, fact);
        ReplicationUtils.createReceiverRoute(receiverGroupId, bufferRouteKey, consumerIdKey, consumerId, NormalizedDouble.class, fact);
    }

    private static void launchJointPropConsumer(String consumerIdKey, String consumerId, JointProperty prop, ManagedServiceFactory fact) {
        JointPropertyListener listener = new JointPropertyListener(prop);
        DefaultConsumerNode consumer = new DefaultConsumerNode((Listener)new ListenerChain((Adapter)new Event.EventDataAdapter(), listener));
        consumer.start();
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)consumer, ConsumerNode.class, consumerIdKey, consumerId, null);
        fact.createService((ServiceLifecycleProvider)lifecycle, null).start();
    }

    public static <T> Configuration<String> buildRobotReplicationLifecycleConfig(final BundleContext context, final String connectConfigId, final String destConfigId, final long replicationPeriod) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theRobotHost, RemoteRobotHost.class, null, null));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Object.class.getName()}, null, deps, (Adapter)new Adapter<Map<String, Object>, Object>(){

            public Object adapt(Map<String, Object> a) {
                RemoteRobotHost host = (RemoteRobotHost)a.get(RobotReplicator.theRobotHost);
                MessageSender sender = host.getResponseSender();
                final Robot r = host.getRobot();
                Listener<RobotResponse> l = new Listener<RobotResponse>(){
                    private boolean myRunFlag = true;

                    public void handleEvent(RobotResponse input) {
                        if (this.myRunFlag && input instanceof RobotDefinitionResponse) {
                            RobotReplicator.startRobotReplicator(context, r.getRobotId().getRobtIdString(), connectConfigId, destConfigId, r.getJointList(), replicationPeriod, null, (ManagedServiceFactory)new OSGiComponentFactory(context));
                            this.myRunFlag = false;
                        }
                    }
                };
                sender.addListener((Listener)l);
                return new Object();
            }
        }));
    }

    public static <T> Configuration<String> buildRobotReceiverLifecycleConfig(final BundleContext context, final String connectConfigId, final String destConfigId) {
        List<Configuration> deps = Arrays.asList(RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theRemoteRobot, RemoteRobot.class, null, null));
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Object.class.getName()}, null, deps, (Adapter)new Adapter<Map<String, Object>, Object>(){

            public Object adapt(Map<String, Object> a) {
                RemoteRobot r = (RemoteRobot)a.get(RobotReplicator.theRemoteRobot);
                RobotReplicator.startRobotReceiver(r.getRobotId().getRobtIdString(), connectConfigId, destConfigId, r.getJointList(), null, (ManagedServiceFactory)new OSGiComponentFactory(context));
                return new Object();
            }
        }));
    }

    static class JointPropertyListener<T>
    implements Listener<NormalizedDouble> {
        private JointProperty<T> myProperty;

        public JointPropertyListener(JointProperty<T> property) {
            if (property == null) {
                throw new NullPointerException();
            }
            this.myProperty = property;
        }

        public void handleEvent(NormalizedDouble input) {
            if (!this.myProperty.getWriteable()) {
                return;
            }
            NormalizableRange range = this.myProperty.getNormalizableRange();
            if (input == null || range == null) {
                return;
            }
            Object t = range.denormalizeValue(input);
            if (t != null) {
                this.myProperty.setValue(t);
            }
        }
    }

    static class JointPropertySource<T>
    implements Source<NormalizedDouble> {
        private JointProperty<T> myProperty;

        public JointPropertySource(JointProperty<T> property) {
            if (property == null) {
                throw new NullPointerException();
            }
            this.myProperty = property;
        }

        public NormalizedDouble getValue() {
            Object t = this.myProperty.getValue();
            NormalizableRange range = this.myProperty.getNormalizableRange();
            if (t == null || range == null) {
                return null;
            }
            return range.normalizeValue(t);
        }
    }
}

