/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.robot.treetable;

import org.netbeans.swing.outline.RowModel;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.ServoJoint;
import org.robokind.api.motion.servos.utils.ConnectionStatus;

public class RobotTreeRowModel
implements RowModel {
    private static final String[] theColumns = new String[]{"Type", "Id", "Enabled", "Status", "Connection", "Errors"};

    public int getColumnCount() {
        return theColumns.length;
    }

    public Object getValueFor(Object node, int column) {
        if (node == null) {
            return null;
        }
        if (node instanceof Robot) {
            return this.getValueForRobot((Robot)node, column);
        }
        if (node instanceof ServoController) {
            return this.getValueForServoController((ServoController)node, column);
        }
        if (node instanceof ServoJoint) {
            return this.getValueForServo(((ServoJoint)node).getServo(), column);
        }
        if (node instanceof Joint) {
            return this.getValueForJoint((Joint)node, column);
        }
        if (node instanceof Servo) {
            return this.getValueForServo((Servo)node, column);
        }
        return null;
    }

    public Object getValueForRobot(Robot robot, int column) {
        switch (column) {
            case 0: {
                return robot.getClass().getSimpleName();
            }
            case 1: {
                return robot.getRobotId();
            }
            case 2: {
                return robot.isEnabled();
            }
            case 3: {
                return robot.isConnected() ? "Connected" : "Disconnected";
            }
            case 4: {
                return robot.isConnected() ? "Disconnect" : "Connect";
            }
            case 5: {
                return "---";
            }
        }
        return null;
    }

    public Object getValueForServoController(ServoController controller, int column) {
        switch (column) {
            case 0: {
                return controller.getClass().getSimpleName();
            }
            case 1: {
                return controller.getId();
            }
            case 2: {
                return controller.getEnabled();
            }
            case 3: {
                return controller.getConnectionStatus();
            }
            case 4: {
                return this.handleServoControllerStatus(controller);
            }
            case 5: {
                return "---";
            }
        }
        return null;
    }

    private Object handleServoControllerStatus(ServoController controller) {
        ConnectionStatus status = controller.getConnectionStatus();
        switch (status) {
            case CONNECTED: {
                return "Disconnect";
            }
            case DISCONNECTED: {
                return "Connect";
            }
            case CONNECTION_ERROR: {
                return "Clear Errors";
            }
        }
        return null;
    }

    public Object getValueForJoint(Joint joint, int column) {
        switch (column) {
            case 0: {
                return joint.getClass().getSimpleName();
            }
            case 1: {
                return joint.getId();
            }
            case 2: {
                return joint.getEnabled();
            }
            case 3: {
                return "";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "";
            }
        }
        return null;
    }

    public Object getValueForServo(Servo servo, int column) {
        switch (column) {
            case 0: {
                return servo.getClass().getSimpleName();
            }
            case 1: {
                return servo.getId();
            }
            case 2: {
                return servo.getEnabled();
            }
            case 3: {
                return "";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "";
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        return column == 2 ? Boolean.class : String.class;
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 2;
    }

    public void setValueFor(Object node, int column, Object value) {
        if (value == null || !(value instanceof Boolean) || node == null || !this.isCellEditable(node, column)) {
            return;
        }
        Boolean val = (Boolean)value;
        if (node instanceof Joint) {
            Joint joint = (Joint)node;
            joint.setEnabled(val);
        }
        if (node instanceof Servo) {
            Servo servo = (Servo)node;
            servo.setEnabled(val);
        } else if (node instanceof ServoController) {
            ServoController sc = (ServoController)node;
            sc.setEnabled(val);
        } else if (node instanceof Robot) {
            Robot robot = (Robot)node;
            robot.setEnabled(val.booleanValue());
        }
    }

    public String getColumnName(int column) {
        return theColumns[column];
    }
}

