/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.robot.treetable;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.Servo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.ServoRobot;

public class RobotTreeModel
implements TreeModel {
    private Robot myRobot;

    public RobotTreeModel(Robot robot) {
        this.myRobot = robot;
    }

    @Override
    public Object getRoot() {
        return this.myRobot;
    }

    @Override
    public Object getChild(Object parent, int i) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Joint) {
            return null;
        }
        if (parent instanceof Servo) {
            return null;
        }
        if (parent instanceof ServoController) {
            return ((ServoController)parent).getServos().get(i);
        }
        if (parent instanceof ServoRobot) {
            return this.getServoRobotChild((ServoRobot)parent, i);
        }
        if (parent instanceof Robot) {
            return ((Robot)parent).getJointList().get(i);
        }
        return null;
    }

    public Object getServoRobotChild(ServoRobot robot, int i) {
        int controllerLen = robot.getControllerList().size();
        if (i < controllerLen) {
            return robot.getControllerList().get(i);
        }
        return robot.getJointList().get(i -= controllerLen);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        if (parent instanceof Joint) {
            return 0;
        }
        if (parent instanceof Servo) {
            return 0;
        }
        if (parent instanceof ServoController) {
            return ((ServoController)parent).getServos().size();
        }
        if (parent instanceof ServoRobot) {
            ServoRobot robot = (ServoRobot)parent;
            int count = robot.getControllerList().size();
            return count += robot.getJointList().size();
        }
        if (parent instanceof Robot) {
            return ((Robot)parent).getJointList().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object o) {
        if (o == null || o instanceof Joint || o instanceof Servo) {
            return true;
        }
        return this.getChildCount(o) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath tp, Object o) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        if (parent instanceof Joint) {
            return -1;
        }
        if (parent instanceof ServoController) {
            if (!(child instanceof Servo)) {
                return -1;
            }
            return ((ServoController)parent).getServos().indexOf(child);
        }
        if (parent instanceof ServoRobot) {
            ServoRobot robot = (ServoRobot)parent;
            if (child instanceof ServoController) {
                return robot.getControllerList().indexOf(child);
            }
            if (child instanceof Joint) {
                int controllerLen = robot.getControllerList().size();
                return robot.getJointList().indexOf(child) + controllerLen;
            }
            return -1;
        }
        if (parent instanceof Robot) {
            if (!(child instanceof Joint)) {
                return -1;
            }
            return ((Robot)parent).getJointList().indexOf(child);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener tl) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener tl) {
    }
}

