/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.jointgroup;

import java.util.List;
import org.netbeans.swing.outline.RowModel;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.jointgroup.JointGroup;

public class JointTreeRowModel
implements RowModel {
    public static final int theColCount = 2;
    private List<String> myProperties;
    private static final int thePropStringLen = 7;

    public JointTreeRowModel(List<String> props) {
        this.myProperties = props;
    }

    public int getColumnCount() {
        if (this.myProperties == null) {
            return 2;
        }
        return 2 + this.myProperties.size();
    }

    public Object getValueFor(Object node, int column) {
        if (node instanceof JointGroup) {
            JointGroup group = (JointGroup)node;
            switch (column) {
                case 0: {
                    return group.getEnabled();
                }
            }
            return null;
        }
        if (!(node instanceof Joint)) {
            return null;
        }
        Joint joint = (Joint)node;
        if (joint == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return joint.getEnabled();
            }
            case 1: {
                return this.getGoalPos(joint);
            }
        }
        return this.getPropertyValue(joint, column - 2);
    }

    private Object getPropertyValue(Joint j, int i) {
        if (this.myProperties == null || i < 0 || i >= this.myProperties.size()) {
            return null;
        }
        String name = this.myProperties.get(i);
        JointProperty prop = j.getProperty(name);
        if (prop == null) {
            return null;
        }
        Object cached = prop.getValue();
        if (cached == null) {
            return null;
        }
        String ret = cached.toString();
        if (ret.length() > 7) {
            return ret.substring(0, 6);
        }
        return ret;
    }

    private String getGoalPos(Joint j) {
        String ret;
        NormalizedDouble pos = j.getGoalPosition();
        if (pos == null) {
            pos = new NormalizedDouble(0.0);
        }
        if ((ret = pos.toString()).length() > 7) {
            return ret.substring(0, 6);
        }
        return ret;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        int i = column - 2;
        if (i < 0 || i >= this.myProperties.size()) {
            return null;
        }
        return String.class;
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 0;
    }

    public void setValueFor(Object node, int column, Object value) {
        if (column != 0 || node == null || value == null || !(value instanceof Boolean)) {
            return;
        }
        Boolean val = (Boolean)value;
        if (node instanceof Joint) {
            Joint joint = (Joint)node;
            joint.setEnabled(val);
        } else if (node instanceof JointGroup) {
            JointGroup jg = (JointGroup)node;
            jg.setEnabled(val.booleanValue());
        }
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Goal";
            }
        }
        int i = column - 2;
        if (i < 0 || i >= this.myProperties.size()) {
            return null;
        }
        return this.myProperties.get(i);
    }
}

