/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.jointgroup;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.ServiceClassListener;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.rwshop.swing.motion.jointgroup.JointGroupTreeModel;
import org.rwshop.swing.motion.jointgroup.JointTreeJointGroupListener;
import org.rwshop.swing.motion.jointgroup.JointTreeRenderer;
import org.rwshop.swing.motion.jointgroup.JointTreeRowModel;

public class JointTreePanel
extends JPanel {
    private JointGroup myRootGroup;
    private JointTreeRowModel myRowModel;
    private JointGroupTreeModel myTreeModel;
    private JointTreeJointGroupListener myListenerTree;
    private List<String> myPropertyNames;
    private ServiceClassListener<JointGroup> myGroupTracker;
    private boolean myInitializedFlag;
    private ScheduledExecutorService s = null;
    private JScrollPane jScrollPane1;
    private Outline myJointTreeOutline;

    public JointTreePanel() {
        this.initComponents();
        this.myPropertyNames = Arrays.asList("absGoalPosition", "currentPosition", "absCurrentPosition", "load", "temperature", "voltage");
        this.myInitializedFlag = false;
    }

    public boolean isInitialized() {
        return this.myInitializedFlag;
    }

    public void initialize(BundleContext context) {
        if (context == null || this.myInitializedFlag) {
            return;
        }
        this.myGroupTracker = new ServiceClassListener<JointGroup>(JointGroup.class, context, null){

            protected void addService(JointGroup t) {
                this.setJointGroup();
            }

            protected void removeService(JointGroup t) {
                this.setJointGroup();
            }

            private void setJointGroup() {
                JointGroup group = (JointGroup)this.getTopService();
                if (group == null) {
                    return;
                }
                if (group == JointTreePanel.this.myRootGroup) {
                    return;
                }
                JointTreePanel.this.setModel(group, JointTreePanel.this.myPropertyNames);
            }
        };
        this.myGroupTracker.start();
        this.myInitializedFlag = true;
    }

    protected void setModel(JointGroup rootGroup, List<String> propNames) {
        this.myRootGroup = rootGroup;
        this.myPropertyNames = propNames;
        this.myRowModel = new JointTreeRowModel(this.myPropertyNames);
        this.myTreeModel = new JointGroupTreeModel(rootGroup);
        OutlineModel mdl = DefaultOutlineModel.createOutlineModel((TreeModel)this.myTreeModel, (RowModel)this.myRowModel);
        this.myJointTreeOutline.setRootVisible(true);
        this.myJointTreeOutline.setModel((TableModel)mdl);
        this.myJointTreeOutline.setRenderDataProvider((RenderDataProvider)new JointTreeRenderer());
        this.jScrollPane1.setViewportView((Component)this.myJointTreeOutline);
        if (this.myListenerTree != null) {
            this.myListenerTree.stopListening();
        }
        this.myListenerTree = JointTreeJointGroupListener.buildListenerTree(this.myRootGroup, this.myJointTreeOutline, this.myPropertyNames);
    }

    public void startUpdates(long interval) {
        final JointTreePanel panel = this;
        if (this.s != null) {
            return;
        }
        this.s = new ScheduledThreadPoolExecutor(1);
        this.s.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    panel.readJointProperties();
                    RepaintManager.currentManager(panel).markCompletelyDirty(panel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, interval, TimeUnit.MILLISECONDS);
    }

    public void stopUpdates() {
        if (this.s == null) {
            return;
        }
        if (!this.s.isShutdown() || !this.s.isTerminated()) {
            this.s.shutdown();
        }
        this.s = null;
    }

    public void readJointProperties() {
        this.readJointPropertiesRec(this.myRootGroup, this.myPropertyNames);
    }

    private void readJointPropertiesRec(JointGroup<?, JointGroup, Joint> group, List<String> props) {
        for (Joint j : group.getJoints()) {
            if (j == null) continue;
            for (String s : props) {
                JointProperty jp = j.getProperty(s);
                if (jp == null) continue;
                jp.getValue();
            }
        }
        for (JointGroup g : group.getJointGroups()) {
            this.readJointPropertiesRec(g, props);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.myJointTreeOutline = new Outline();
        this.jScrollPane1.setViewportView((Component)this.myJointTreeOutline);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 158, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 161, Short.MAX_VALUE));
    }
}

