/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.jointgroup;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.rwshop.swing.motion.jointgroup.JointGroupTreeModel;
import org.rwshop.swing.motion.jointgroup.JointTreeJointListener;
import org.rwshop.swing.motion.jointgroup.JointTreeRowModel;

public class JointTreeJointGroupListener
implements PropertyChangeListener {
    private Outline myJointTree;
    private JointGroup<?, JointGroup, Joint> myJointGroup;
    int myRow;
    private List<JointTreeJointListener> myJointListeners;
    private List<JointTreeJointGroupListener> myGroupListeners;
    private List<String> myPropNames;

    public static JointTreeJointGroupListener buildListenerTree(JointGroup rootGroup, Outline jointTree, List<String> propNames) {
        JointTreeJointGroupListener groupListener = new JointTreeJointGroupListener(rootGroup, jointTree, propNames);
        groupListener.setRow(0);
        return groupListener;
    }

    public JointTreeJointGroupListener(JointGroup group, Outline jointTree, List<String> propNames) {
        this.myPropNames = propNames;
        this.myJointTree = jointTree;
        this.myJointGroup = group;
        this.myJointListeners = new ArrayList<JointTreeJointListener>(this.myJointGroup.getJointCount());
        this.myGroupListeners = new ArrayList<JointTreeJointGroupListener>(this.myJointGroup.getGroupCount());
        this.buildListeners();
    }

    private void buildListeners() {
        this.myJointGroup.addPropertyChangeListener((PropertyChangeListener)this);
        for (Joint j : this.myJointGroup.getJoints()) {
            if (j == null) continue;
            JointTreeJointListener jtjl = new JointTreeJointListener(j, this.myJointTree, this.myPropNames);
            this.myJointListeners.add(jtjl);
        }
        for (JointGroup g : this.myJointGroup.getJointGroups()) {
            JointTreeJointGroupListener jtjgl = new JointTreeJointGroupListener(g, this.myJointTree, this.myPropNames);
            this.myGroupListeners.add(jtjgl);
        }
    }

    public void stopListening() {
        this.myJointGroup.removePropertyChangeListener((PropertyChangeListener)this);
        for (JointTreeJointListener jointTreeJointListener : this.myJointListeners) {
            jointTreeJointListener.stopListening();
        }
        this.myJointListeners.clear();
        for (JointTreeJointGroupListener jointTreeJointGroupListener : this.myGroupListeners) {
            jointTreeJointGroupListener.stopListening();
        }
        this.myGroupListeners.clear();
    }

    public int setRow(int r) {
        this.myRow = r;
        for (JointTreeJointListener jointListener : this.myJointListeners) {
            jointListener.setRow(++r);
        }
        for (JointTreeJointGroupListener groupListener : this.myGroupListeners) {
            ++r;
            r = groupListener.setRow(r);
        }
        return r;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        Integer i = null;
        if ("enabled".equals(name)) {
            i = 1;
        } else if ("name".equals(name)) {
            i = 0;
        } else if ("structureChanged".equals(name)) {
            this.stopListening();
            this.buildListeners();
            try {
                SwingUtilities.invokeLater(new UpdateRunnable());
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        if (i == null) {
            return;
        }
        Rectangle cell = this.myJointTree.getCellRect(this.myRow, i.intValue(), false);
        this.myJointTree.repaint(cell);
    }

    private class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            JointTreeJointGroupListener.this.setRow(JointTreeJointGroupListener.this.myRow);
            JointTreeRowModel rm = new JointTreeRowModel(JointTreeJointGroupListener.this.myPropNames);
            JointGroupTreeModel tm = new JointGroupTreeModel(JointTreeJointGroupListener.this.myJointGroup);
            OutlineModel mdl = DefaultOutlineModel.createOutlineModel((TreeModel)tm, (RowModel)rm);
            JointTreeJointGroupListener.this.myJointTree.setModel((TableModel)mdl);
            JointTreeJointGroupListener.this.myJointTree.repaint();
        }
    }
}

