/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.motion.jointgroup;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.jointgroup.JointGroup;

public class JointGroupTreeModel
implements TreeModel {
    private JointGroup myJointGroup;

    public JointGroupTreeModel(JointGroup group) {
        this.myJointGroup = group;
    }

    @Override
    public Object getRoot() {
        return this.myJointGroup;
    }

    @Override
    public Object getChild(Object parent, int i) {
        if (!(parent instanceof JointGroup)) {
            return null;
        }
        JointGroup group = (JointGroup)parent;
        int jointCount = group.getJointCount();
        if (i < jointCount) {
            Joint j = group.getJoint(i);
            if (j == null) {
                return group.getJointId(i);
            }
            return group.getJoint(i);
        }
        if ((i -= jointCount) > group.getGroupCount()) {
            return null;
        }
        return group.getJointGroups().get(i);
    }

    @Override
    public int getChildCount(Object parent) {
        if (!(parent instanceof JointGroup)) {
            return 0;
        }
        JointGroup group = (JointGroup)parent;
        return group.getJointCount() + group.getGroupCount();
    }

    @Override
    public boolean isLeaf(Object o) {
        if (!(o instanceof JointGroup)) {
            return true;
        }
        JointGroup group = (JointGroup)o;
        return group.getJointCount() == 0 && group.getGroupCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath tp, Object o) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!(parent instanceof JointGroup)) {
            return -1;
        }
        JointGroup group = (JointGroup)parent;
        if (child instanceof Integer) {
            return group.getJointIds().indexOf((Integer)child);
        }
        if (child instanceof JointGroup) {
            int index = group.getJointGroups().indexOf((JointGroup)child);
            if (index == -1) {
                return -1;
            }
            int joints = group.getJointCount();
            return joints + index;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener tl) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener tl) {
    }
}

