/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoRobotConfig;
import org.rwshop.nb.motion.nodes.JointControllerNode;
import org.rwshop.nb.motion.nodes.JointNode;
import org.rwshop.nb.motion.nodes.RobotConfigNode;

public class RobotNode
extends AbstractNode
implements PropertyChangeListener {
    public RobotNode(Robot dev) {
        super((Children)new RobotNodeChildren(dev), Lookups.singleton((Object)dev));
        if (dev == null) {
            throw new NullPointerException("Cannot create RobotNode with null Robot.");
        }
        this.setDisplayName(dev.getRobotId().toString());
    }

    public String getHtmlDisplayName() {
        Robot dev = (Robot)this.getLookup().lookup(Robot.class);
        if (dev != null) {
            return "<font color='!textText'>" + this.getName() + " </font><font color='!controlShadow'><i>(" + dev.getClass().getSimpleName() + ")</i></font>";
        }
        return null;
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/myorg/myeditor/icon.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Node.Property[] getProperties() throws NoSuchMethodException {
        return new Node.Property[0];
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        try {
            set.put(this.getProperties());
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault();
        }
        sheet.put(set);
        Node node = this.getChildren().findChild(ServoRobotConfig.class.getName());
        if (node != null) {
            Sheet.Set[] sets;
            RobotConfigNode confNode = (RobotConfigNode)node;
            for (Sheet.Set confSet : sets = confNode.getPropertySheetSets()) {
                sheet.put(confSet);
            }
        }
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static class RobotNodeChildren
    extends Children.Keys {
        private Robot myRobot;

        public RobotNodeChildren(Robot robot) {
            this.myRobot = robot;
        }

        protected void addNotify() {
            super.addNotify();
            LinkedList keys = new LinkedList();
            keys.addAll(this.myRobot.getJointList());
            this.setKeys(keys);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof ServoRobotConfig) {
                return new Node[]{new RobotConfigNode((ServoRobotConfig)key)};
            }
            if (key instanceof ServoController) {
                return new Node[]{new JointControllerNode((ServoController)key)};
            }
            if (key instanceof Joint) {
                return new Node[]{new JointNode((Joint)key)};
            }
            return null;
        }
    }
}

