/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.robokind.api.motion.Joint;

public class JointNode
extends AbstractNode
implements PropertyChangeListener {
    public JointNode(Joint joint) {
        super(Children.LEAF, Lookups.singleton((Object)joint));
        if (joint == null) {
            throw new NullPointerException("Cannot create JointNode with null Joint.");
        }
        this.setDisplayName(joint.getName());
        joint.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)joint));
    }

    public String getHtmlDisplayName() {
        Joint joint = (Joint)this.getLookup().lookup(Joint.class);
        if (joint != null) {
            return "<font color='!textText'>" + joint.getName() + " </font><font color='!controlShadow'><i>(" + joint.getClass().getSimpleName() + ")</i></font>";
        }
        return null;
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/myorg/myeditor/icon.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Node.Property[] getProperties() throws NoSuchMethodException {
        Joint obj = (Joint)this.getLookup().lookup(Joint.class);
        PropertySupport.Reflection goalPosProp = new PropertySupport.Reflection((Object)obj, Double.class, "goalPosition");
        goalPosProp.setName("Goal Position");
        PropertySupport.Reflection enabledProp = new PropertySupport.Reflection((Object)obj, Boolean.class, "enabled");
        enabledProp.setName("Enabled");
        return new Node.Property[]{goalPosProp, enabledProp};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        try {
            set.put(this.getProperties());
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault();
        }
        set.setName("Joint Properties");
        set.setDisplayName("Joint Properties");
        sheet.put(set);
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

