/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoControllerConfig;
import org.rwshop.nb.motion.nodes.ControllerConfigNode;
import org.rwshop.nb.motion.nodes.JointNode;

public class JointControllerNode
extends AbstractNode
implements PropertyChangeListener {
    public JointControllerNode(ServoController controller) {
        super((Children)new JointControllerChildren(controller), Lookups.singleton((Object)controller));
        if (controller == null) {
            throw new NullPointerException("Cannot create JointNode with null Joint.");
        }
        ServoControllerConfig config = controller.getConfig();
        this.setDisplayName(config.getServoControllerId().toString());
        controller.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)controller));
    }

    public String getHtmlDisplayName() {
        ServoController controller = (ServoController)this.getLookup().lookup(ServoController.class);
        if (controller != null) {
            ServoControllerConfig conf = controller.getConfig();
            return "<font color='!textText'>" + conf.getServoControllerId() + " </font><font color='!controlShadow'><i>(" + controller.getClass().getSimpleName() + ")</i></font>";
        }
        return null;
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/myorg/myeditor/icon.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Node.Property[] getProperties() throws NoSuchMethodException {
        ServoController obj = (ServoController)this.getLookup().lookup(ServoController.class);
        if (obj == null) {
            return new Node.Property[0];
        }
        PropertySupport.Reflection enabledProp = new PropertySupport.Reflection((Object)obj, Boolean.class, "enabled");
        enabledProp.setName("Enabled");
        return new Node.Property[]{enabledProp};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        try {
            set.put(this.getProperties());
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault();
        }
        set.setName("JointController Properties");
        set.setDisplayName("JointController Properties");
        sheet.put(set);
        Node node = this.getChildren().findChild(ServoControllerConfig.class.getName());
        if (node != null) {
            Sheet.Set[] sets;
            ControllerConfigNode confNode = (ControllerConfigNode)node;
            for (Sheet.Set confSet : sets = confNode.getPropertySheetSets()) {
                sheet.put(confSet);
            }
        }
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static class JointControllerChildren
    extends Children.Keys {
        private ServoController myController;

        public JointControllerChildren(ServoController controller) {
            this.myController = controller;
        }

        protected void addNotify() {
            super.addNotify();
            LinkedList<ServoControllerConfig> keys = new LinkedList<ServoControllerConfig>();
            ServoControllerConfig conf = this.myController.getConfig();
            if (conf != null) {
                keys.add(this.myController.getConfig());
            }
            this.setKeys(keys);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Joint) {
                return new Node[]{new JointNode((Joint)key)};
            }
            if (key instanceof ServoControllerConfig) {
                return new Node[]{new ControllerConfigNode((ServoControllerConfig)key)};
            }
            return null;
        }
    }
}

