/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.robokind.api.motion.servos.config.ServoConfig;

public class JointConfigNode
extends AbstractNode
implements PropertyChangeListener {
    private static final Logger theLogger = Logger.getLogger(JointConfigNode.class.getName());

    public JointConfigNode(ServoConfig config) {
        super(Children.LEAF, Lookups.singleton((Object)config));
        if (config == null) {
            throw new NullPointerException("Cannot create JointConfigNode with null JointConfig.");
        }
        this.setName(ServoConfig.class.getName());
        this.setDisplayName(config.getName() + " (config)");
        config.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)config));
    }

    public String getHtmlDisplayName() {
        ServoConfig obj = (ServoConfig)this.getLookup().lookup(ServoConfig.class);
        if (obj != null) {
            return "<font color='!textText'>" + obj.getName() + " </font><font color='!controlShadow'><i>(" + obj.getClass().getSimpleName() + ")</i></font>";
        }
        return null;
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/myorg/myeditor/icon.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Node.Property[] getProperties() throws NoSuchMethodException {
        ServoConfig obj = (ServoConfig)this.getLookup().lookup(ServoConfig.class);
        PropertySupport.Reflection logIdProp = new PropertySupport.Reflection((Object)obj, Integer.class, "logicalId");
        logIdProp.setName("Servo Id");
        PropertySupport.Reflection nameProp = new PropertySupport.Reflection((Object)obj, String.class, "name");
        nameProp.setName("Name");
        PropertySupport.Reflection minPosProp = new PropertySupport.Reflection((Object)obj, Integer.class, "minPosition");
        minPosProp.setName("Minimum Position");
        PropertySupport.Reflection maxPosProp = new PropertySupport.Reflection((Object)obj, Integer.class, "maxPosition");
        maxPosProp.setName("Maximum Position");
        PropertySupport.Reflection defPosProp = new PropertySupport.Reflection((Object)obj, Integer.class, "defaultPosition");
        defPosProp.setName("Default Position");
        return new Node.Property[]{logIdProp, nameProp, minPosProp, maxPosProp, defPosProp};
    }

    protected Sheet.Set[] getPropertySheetSets() {
        Sheet.Set set = Sheet.createPropertiesSet();
        try {
            set.put(this.getProperties());
        }
        catch (NoSuchMethodException ex) {
            theLogger.log(Level.SEVERE, "Error creating PropertySheets.", ex);
        }
        return new Sheet.Set[]{set};
    }

    protected Sheet createSheet() {
        Sheet.Set[] sets;
        Sheet sheet = Sheet.createDefault();
        for (Sheet.Set set : sets = this.getPropertySheetSets()) {
            sheet.put(set);
        }
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }
}

