/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.config.ServoControllerConfig;
import org.rwshop.nb.common.VersionPropertySheet;
import org.rwshop.nb.motion.nodes.JointConfigNode;

public class ControllerConfigNode
extends AbstractNode
implements PropertyChangeListener {
    public ControllerConfigNode(ServoControllerConfig config) {
        super((Children)new ControllerConfigChildren(config), Lookups.singleton((Object)config));
        if (config == null) {
            throw new NullPointerException("Cannot create ControllerConfigNode with null ControllerConfig.");
        }
        this.setName(ServoControllerConfig.class.getName());
        this.setDisplayName(config.getServoControllerId().toString());
        config.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)config));
    }

    public String getHtmlDisplayName() {
        ServoControllerConfig conf = (ServoControllerConfig)this.getLookup().lookup(ServoControllerConfig.class);
        if (conf != null) {
            return "<font color='!textText'>" + conf.getServoControllerId().toString() + " </font><font color='!controlShadow'><i>(" + conf.getClass().getSimpleName() + ")</i></font>";
        }
        return null;
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/myorg/myeditor/icon.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Node.Property[] getProperties() throws NoSuchMethodException {
        ServoConfig obj = (ServoConfig)this.getLookup().lookup(ServoConfig.class);
        return new Node.Property[0];
    }

    protected Sheet.Set[] getPropertySheetSets() {
        ServoControllerConfig conf = (ServoControllerConfig)this.getLookup().lookup(ServoControllerConfig.class);
        if (conf == null) {
            return new Sheet.Set[0];
        }
        ArrayList<Sheet.Set> sets = new ArrayList<Sheet.Set>(2);
        try {
            Sheet.Set versionSet = VersionPropertySheet.getVersionPropertySheetSet((String)"Version", (String)"Joint Config", (Object)conf);
            sets.add(versionSet);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        try {
            Sheet.Set controllerTypSet = VersionPropertySheet.getVersionPropertySheetSet((String)"ControllerTypeVersion", (String)"Controller Type", (Object)conf);
            sets.add(controllerTypSet);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return sets.toArray(new Sheet.Set[0]);
    }

    protected Sheet createSheet() {
        Sheet.Set[] sets;
        Sheet sheet = Sheet.createDefault();
        for (Sheet.Set set : sets = this.getPropertySheetSets()) {
            sheet.put(set);
        }
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static class ControllerConfigChildren
    extends Children.Keys<ServoConfig> {
        private ServoControllerConfig myConfig;

        public ControllerConfigChildren(ServoControllerConfig controller) {
            this.myConfig = controller;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.myConfig.getServoConfigs().values());
        }

        protected Node[] createNodes(ServoConfig key) {
            return new JointConfigNode[]{new JointConfigNode(key)};
        }
    }
}

