/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.swing.JFileChooser;
import org.apache.qpid.client.AMQQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.services.ServiceConnectionDirectory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.sync.SynchronizedRobot;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigLoader;

public final class ConnectSynchronizedRobotAction
implements ActionListener {
    private static final Logger theLogger = Logger.getLogger(ConnectSynchronizedRobotAction.class.getName());
    private static final long theDefaultBlenderInterval = 40L;

    @Override
    public void actionPerformed(ActionEvent e) {
        Robot robot;
        File file = this.chooseFile();
        if (file == null) {
            return;
        }
        BundleContext context = OSGiUtils.getBundleContext(Robot.class);
        if (context == null) {
            theLogger.warning("Unable to load Robot.  Could not find BundleContext.");
            return;
        }
        try {
            robot = (Robot)ServiceConnectionDirectory.buildService((BundleContext)context, (VersionProperty)SynchronizedRobot.VERSION, (VersionProperty)SynchronizedRobotConfigLoader.VERSION, (Object)file, File.class, Robot.class);
            if (robot == null) {
                return;
            }
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Unable to load Robot.  Could not build service.", ex);
            return;
        }
        robot.connect();
        ServiceRegistration reg = RobotUtils.registerRobot((BundleContext)context, (Robot)robot, null);
        if (reg == null) {
            theLogger.log(Level.INFO, "Failed registering Robot service.");
            return;
        }
        theLogger.log(Level.INFO, "Robot Service Registered.");
        RobotUtils.startDefaultBlender((BundleContext)context, (Robot.Id)robot.getRobotId(), (long)40L);
        ConnectSynchronizedRobotAction.createAndRegisterServer(context, robot);
    }

    private File chooseFile() {
        JFileChooser chooser = new JFileChooser();
        int ret = chooser.showOpenDialog(null);
        if (ret != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    private File predfinedFile(String path) {
        return ConfigUtils.getFileSystemAdapter().openFile(path);
    }

    private static void createAndRegisterServer(BundleContext bundleCtx, Robot robot) {
        Connection connection = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        if (connection == null) {
            return;
        }
        try {
            connection.start();
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Could not start connection.", ex);
            return;
        }
        if (connection == null) {
            return;
        }
        String queue = "robotMotionFrame; {create: always, node: {type: queue}}";
        try {
            Session session = connection.createSession(false, 2);
            AMQQueue destination = new AMQQueue(queue);
        }
        catch (URISyntaxException ex) {
            theLogger.log(Level.WARNING, "Error creating destination.", ex);
            return;
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error creating session.", ex);
            return;
        }
    }
}

