/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.swing.JOptionPane;
import org.jflux.api.core.Adapter;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.lifecycle.RemoteRobotClientLifecycle;
import org.robokind.api.motion.lifecycle.RemoteRobotLifecycle;
import org.robokind.api.motion.messaging.RobotRequestFactory;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.avrogen.motion.MotionFrameEventRecord;
import org.robokind.avrogen.motion.RobotRequestRecord;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.messaging.lifecycle.BytesMessageBlockingReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroMessageSenderLifecycle;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.messaging.utils.ConnectionUtils;
import org.robokind.impl.motion.messaging.PortableMotionFrameEvent;
import org.robokind.impl.motion.messaging.PortableRobotRequest;
import org.robokind.impl.motion.messaging.PortableRobotResponse;
import org.rwshop.nb.motion.actions.ConnectAction;

public final class ConnectRemoteRobotAction
implements ActionListener {
    private static final Logger theLogger = Logger.getLogger(ConnectRemoteRobotAction.class.getName());
    private static final String CONNECTION_ID = "motionConnection";
    private static final String REQUEST_DEST_ID = "robotRequest";
    private static final String RESPONSE_DEST_ID = "robotResponse";
    private static final String MOVE_DEST_ID = "robotMotionFrame";
    private static final Robot.Id ROBOT_ID = new Robot.Id("myRobot");
    private static final String REQUEST_SENDER_ID = "robotRequestSender";
    private static final String RESPONSE_RECEIVER_ID = "robotResponseReceiver";
    private static final String MOVE_SENDER_ID = "robotFrameSender";

    @Override
    public void actionPerformed(ActionEvent e) {
        String ip = JOptionPane.showInputDialog("Remote Robot IP ?", (Object)"127.0.0.1");
        if (ip == null) {
            theLogger.info("User cancelled ConnectRemoteRobot action.");
            return;
        }
        if (ip.isEmpty()) {
            ip = "127.0.0.1";
        }
        String tcp = "tcp://" + ip + ":5672";
        theLogger.info(tcp);
        BundleContext context = OSGiUtils.getBundleContext(Robot.class);
        if (context == null) {
            theLogger.warning("Unable to load Robot.  Could not find BundleContext.");
            return;
        }
        String connectionConfigId = "robotReceiverConnectionConfig";
        RKMessagingConfigUtils.registerConnectionConfig((String)connectionConfigId, (String)ip, null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        ConnectRemoteRobotAction.startRemoteRobotClientServices(context, CONNECTION_ID, REQUEST_DEST_ID, RESPONSE_DEST_ID, MOVE_DEST_ID, REQUEST_SENDER_ID, RESPONSE_RECEIVER_ID, MOVE_SENDER_ID);
        this.connectMotion(context, tcp, CONNECTION_ID, REQUEST_DEST_ID, RESPONSE_DEST_ID, MOVE_DEST_ID);
        ConnectAction.loadJointGroup(context, ROBOT_ID, "./resources/jointgroup.xml");
        ConnectRemoteRobotAction.startRobotClientLifecycle(context, "source", "dest", ROBOT_ID, REQUEST_SENDER_ID, RESPONSE_RECEIVER_ID, MOVE_SENDER_ID);
        ConnectRemoteRobotAction.startRemoteRobot(context, ROBOT_ID);
        RobotUtils.startDefaultBlender((BundleContext)context, (Robot.Id)ROBOT_ID, (long)40L);
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableMotionFrameEvent.Factory(), MotionFrameEvent.MotionFrameEventFactory.class)).start();
    }

    private static void startRobotClientLifecycle(BundleContext context, String sourceId, String destId, Robot.Id robotId, String reqSenderId, String respReceiverId, String frameSenderId) {
        RemoteRobotClientLifecycle lifecycle = new RemoteRobotClientLifecycle(sourceId, destId, robotId, reqSenderId, respReceiverId, frameSenderId);
        OSGiComponent comp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        comp.start();
    }

    private static void startRemoteRobot(BundleContext context, Robot.Id robotId) {
        RemoteRobotLifecycle lifecycle = new RemoteRobotLifecycle(robotId);
        OSGiComponent comp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        comp.start();
    }

    private void connectMotion(BundleContext context, String connectionStr, String connectionId, String requestDestId, String responseDestId, String moveDestId) {
        theLogger.info("Registering Motion Connection and Destinations");
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)connectionStr);
        if (con == null) {
            return;
        }
        try {
            con.start();
        }
        catch (JMSException ex) {
            theLogger.log(Level.SEVERE, "Unable to start connection: " + connectionId, ex);
            return;
        }
        ConnectionUtils.ensureSession((BundleContext)context, (String)connectionId, (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{requestDestId, "robotmyRobothostrobotRequest", 1, null, responseDestId, "robotmyRobothostrobotResponse", 1, null, moveDestId, "robotmyRobothostmotionFrame", 1, null});
        theLogger.info("Motion Connection and Destinations Registered");
    }

    private static void startRemoteRobotClientServices(BundleContext context, String connectionId, String requestDestId, String responseDestId, String moveDestId, String requestSenderId, String responseReceiverId, String moveSenderId) {
        BytesMessageBlockingReceiverLifecycle respRecLifecycle = new BytesMessageBlockingReceiverLifecycle((Adapter)new PortableRobotResponse.RecordMessageAdapter(), RobotResponse.class, responseReceiverId, connectionId, responseDestId);
        OSGiComponent respSender = new OSGiComponent(context, (ServiceLifecycleProvider)respRecLifecycle);
        respSender.start();
        JMSAvroMessageSenderLifecycle reqSenderLifecycle = new JMSAvroMessageSenderLifecycle((Adapter)new PortableRobotRequest.MessageRecordAdapter(), RobotRequest.class, RobotRequestRecord.class, requestSenderId, connectionId, requestDestId);
        OSGiComponent reqRec = new OSGiComponent(context, (ServiceLifecycleProvider)reqSenderLifecycle);
        reqRec.start();
        JMSAvroMessageSenderLifecycle moveSenderLifecycle = new JMSAvroMessageSenderLifecycle((Adapter)new PortableMotionFrameEvent.MessageRecordAdapter(), MotionFrameEvent.class, MotionFrameEventRecord.class, moveSenderId, connectionId, moveDestId);
        OSGiComponent moveRec = new OSGiComponent(context, (ServiceLifecycleProvider)moveSenderLifecycle);
        moveRec.start();
        PortableRobotRequest.Factory reqFact = new PortableRobotRequest.Factory();
        OSGiComponent reqFactComp = new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)reqFact, RobotRequestFactory.class));
        reqFactComp.start();
    }
}

