/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.motion.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceParams;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.lifecycle.RobotJointGroupLifecycle;
import org.robokind.api.motion.servos.ServoRobot;
import org.robokind.api.motion.servos.config.ServoRobotConfig;
import org.robokind.api.motion.servos.utils.ServoRobotLifecycle;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.motion.config.RobotConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.impl.motion.lifecycle.RemoteRobotHostServiceGroup;

public final class ConnectAction
implements ActionListener {
    private static final Logger theLogger = Logger.getLogger(ConnectAction.class.getName());
    private static final long theDefaultBlenderInterval = 40L;

    @Override
    public void actionPerformed(ActionEvent e) {
        BundleContext context = OSGiUtils.getBundleContext(Robot.class);
        if (context == null) {
            theLogger.warning("Unable to load Robot.  Could not find BundleContext.");
            return;
        }
        Robot.Id robotId = new Robot.Id("myRobot");
        this.launchRobot(context, robotId, "./resources/robot.xml");
        RobotUtils.startDefaultBlender((BundleContext)context, (Robot.Id)robotId, (long)40L);
        ConnectAction.loadJointGroup(context, robotId, "./resources/jointgroup.xml");
        String connectionConfigId = "remoteRobotConnectionConfig";
        RKMessagingConfigUtils.registerConnectionConfig((String)connectionConfigId, (String)"127.0.0.1", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        new RemoteRobotHostServiceGroup(context, robotId, "host", "client", connectionConfigId, null).start();
    }

    private File chooseFile() {
        JFileChooser chooser = new JFileChooser();
        int ret = chooser.showOpenDialog(null);
        if (ret != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    protected static ServiceRegistration loadJointGroup(BundleContext context, Robot.Id robotId, String configPath) {
        File file = ConfigUtils.getFileSystemAdapter().openFile(configPath);
        if (file == null) {
            return null;
        }
        String paramId = "robot/" + robotId + "/jointgroup/config/param/xml";
        ConnectAction.launchJointGroupConfig(context, file, paramId);
        RobotJointGroupLifecycle lifecycle = new RobotJointGroupLifecycle(robotId, File.class, paramId, RobotJointGroupConfigXMLReader.VERSION);
        OSGiComponent jointGroupComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        jointGroupComp.start();
        return null;
    }

    private static OSGiComponent launchJointGroupConfig(BundleContext context, File file, String paramId) {
        Properties props = new Properties();
        props.put("configParamId", paramId);
        props.put("configFormatVersion", RobotJointGroupConfigXMLReader.VERSION.toString());
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)file, File.class, props);
        OSGiComponent paramComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        paramComp.start();
        return paramComp;
    }

    private ManagedService launchRobot(BundleContext context, Robot.Id robotId, String path) {
        File file = ConfigUtils.getFileSystemAdapter().openFile(path);
        if (file == null) {
            return null;
        }
        String paramId = "robot/" + robotId + "/config/param/xml";
        ConnectAction.launchRobotConfig(context, file, paramId);
        return ConnectAction.loadRobotService(context, robotId, paramId);
    }

    protected static ManagedService loadRobotService(BundleContext context, Robot.Id robotId, String paramId) {
        ConfiguredServiceParams params = new ConfiguredServiceParams(Robot.class, ServoRobotConfig.class, File.class, null, null, paramId, ServoRobot.VERSION, RobotConfigXMLReader.VERSION);
        ServoRobotLifecycle lifecycle = new ServoRobotLifecycle(params, (ManagedServiceFactory)new OSGiComponentFactory(context));
        Properties props = new Properties();
        props.put("robotId", robotId.getRobtIdString());
        OSGiComponent robotComponent = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle, props);
        robotComponent.start();
        return robotComponent;
    }

    private static OSGiComponent launchRobotConfig(BundleContext context, File file, String paramId) {
        Properties props = new Properties();
        props.put("configParamId", paramId);
        props.put("configFormatVersion", RobotConfigXMLReader.VERSION.toString());
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)file, File.class, props);
        OSGiComponent paramComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        paramComp.start();
        return paramComp;
    }
}

