/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class UIHelpers {
    public static void drawLines(Graphics g, List<Point2D> points, CoordinateScalar s) {
        if (points == null) {
            return;
        }
        for (List<Point2D> path : UIHelpers.splitList(points)) {
            UIHelpers.drawLinePath(g, path, s);
        }
    }

    public static List<List<Point2D>> splitList(List<Point2D> points) {
        ArrayList<List<Point2D>> lists = new ArrayList<List<Point2D>>();
        if (points == null) {
            return lists;
        }
        int len = points.size();
        if (len < 2) {
            lists.add(points);
            return lists;
        }
        ArrayList<Integer> breaks = new ArrayList<Integer>();
        if (points.get(0).getY() == -1.0) {
            return UIHelpers.splitList(points.subList(1, len));
        }
        if (points.get(len - 1).getY() == -1.0) {
            return UIHelpers.splitList(points.subList(0, len - 1));
        }
        for (int i = 0; i < points.size(); ++i) {
            Point2D p = points.get(i);
            if (p.getY() != -1.0) continue;
            breaks.add(i);
        }
        if (breaks.isEmpty()) {
            lists.add(points);
            return lists;
        }
        int prev = 0;
        Iterator i$ = breaks.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            lists.add(points.subList(prev, i));
            prev = i + 1;
        }
        lists.add(points.subList(prev, len));
        return lists;
    }

    public static void drawLinePath(Graphics g, List<Point2D> points, CoordinateScalar s) {
        if (points == null) {
            return;
        }
        int len = points.size();
        if (len < 2) {
            return;
        }
        int[] x = new int[len];
        int[] y = new int[len];
        for (int i = 0; i < len; ++i) {
            Point2D p = points.get(i);
            x[i] = (int)s.scaleX(p);
            y[i] = (int)s.scaleY(p);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.drawPolyline(x, y, len);
    }
}

