/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.scaling;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.ScalingManager;

public class ScalingScrollWheelListener
implements MouseWheelListener {
    private JScrollPane myScrollPane;
    private double myScrollRate;
    private ScalingManager myScalingManager;
    private double myPreviousScrollPosition;

    public void init(JScrollPane pane, ScalingManager scalingManager) {
        if (pane == null || scalingManager == null) {
            throw new NullPointerException();
        }
        this.myScrollPane = pane;
        this.myScrollRate = 0.95;
        this.myScalingManager = scalingManager;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isShiftDown()) {
            return;
        }
        CoordinateScalar sc = this.myScalingManager.getScalar();
        double scroll = e.getWheelRotation();
        scroll = Math.pow(this.myScrollRate, scroll);
        if ((scroll *= sc.getScaleX()) >= 5.0 || scroll <= 0.0) {
            return;
        }
        int cursorX = e.getX();
        double val = sc.unscaleX(cursorX);
        double oldVal = this.myScrollPane.getHorizontalScrollBar().getValue();
        if ((double)((int)this.myPreviousScrollPosition) == oldVal) {
            oldVal = this.myPreviousScrollPosition;
        }
        double cursorWindowX = (double)cursorX - oldVal;
        sc.setScaleX(scroll);
        double newKnobX = sc.scaleX(val) - cursorWindowX;
        this.myScalingManager.setFocusPosition((int)newKnobX, null);
        this.myPreviousScrollPosition = newKnobX;
    }
}

