/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.scaling;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.ScalableComponent;

public class ScalingManager {
    private List<ScalableComponent> myComponents;
    private CoordinateScalar myScalar;
    private ScalarListener myScalarListener;

    public ScalingManager(CoordinateScalar scalar) {
        if (scalar == null) {
            throw new NullPointerException();
        }
        this.myScalar = scalar;
        this.myScalarListener = new ScalarListener();
        this.myScalar.addPropertyChangeListener(this.myScalarListener);
        this.myComponents = new ArrayList<ScalableComponent>();
    }

    public CoordinateScalar getScalar() {
        return this.myScalar;
    }

    public void rescaleComponents() {
        int maxWidth = 0;
        int maxHeight = 0;
        for (ScalableComponent component : this.myComponents) {
            maxWidth = Math.max(maxWidth, component.getMinWidth());
            maxHeight = Math.max(maxHeight, component.getMinHeight());
        }
        for (ScalableComponent component : this.myComponents) {
            component.rescale(maxWidth, maxHeight);
        }
    }

    public void setFocusPosition(Integer x, Integer y) {
        for (ScalableComponent component : this.myComponents) {
            component.setFocusPosition(x, y);
        }
    }

    public void addComponent(ScalableComponent component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (this.myComponents.contains(component)) {
            return;
        }
        this.myComponents.add(component);
        component.setScalar(this.myScalar);
        this.rescaleComponents();
    }

    public boolean removeComponent(ScalableComponent component, CoordinateScalar scalar) {
        if (component == null || scalar == null) {
            throw new NullPointerException();
        }
        if (this.myScalar.equals(scalar)) {
            throw new IllegalArgumentException("Cannot reuse LinkScalingManager's CoordinateScalar.  A different one must be provided.");
        }
        if (!this.myComponents.remove(component)) {
            return false;
        }
        component.setScalar(scalar);
        this.rescaleComponents();
        return true;
    }

    private class ScalarListener
    implements PropertyChangeListener {
        private ScalarListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"scaleX".equals(evt.getPropertyName())) {
                return;
            }
            ScalingManager.this.rescaleComponents();
        }
    }
}

