/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.scaling;

import java.awt.geom.Point2D;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class DefaultCoordinateScalar
extends PropertyChangeNotifier
implements CoordinateScalar {
    private double myScaleX;
    private double myScaleY;
    private double myXOffset;
    private double myYOffset;
    private boolean myInvertY;

    public DefaultCoordinateScalar() {
        this.myScaleX = 1.0;
        this.myScaleY = 1.0;
        this.myInvertY = true;
        this.myYOffset = 0.0;
        this.myXOffset = 0.0;
    }

    public DefaultCoordinateScalar(double x, double y, boolean i) {
        this.myScaleX = x;
        this.myScaleY = y;
        this.myInvertY = i;
        this.myYOffset = 0.0;
        this.myXOffset = 0.0;
    }

    @Override
    public double getScaleX() {
        return this.myScaleX;
    }

    @Override
    public void setScaleX(double s) {
        if (s <= 0.0) {
            return;
        }
        double oldVal = this.myScaleX;
        this.myScaleX = Math.min(s, 5.0);
        this.firePropertyChange("scaleX", oldVal, this.myScaleX);
    }

    @Override
    public void setXOffset(double val) {
        double oldVal = this.myXOffset;
        this.myXOffset = val;
        this.firePropertyChange("offsetX", oldVal, this.myXOffset);
    }

    @Override
    public double getScaleY() {
        return this.myScaleY;
    }

    @Override
    public void setScaleY(double s) {
        if (s <= 0.0) {
            return;
        }
        double oldVal = this.myScaleY;
        this.myScaleY = s;
        this.firePropertyChange("scaleY", oldVal, this.myScaleY);
    }

    @Override
    public void setYOffset(double val) {
        double oldVal = this.myYOffset;
        this.myYOffset = val;
        this.firePropertyChange("offsetY", oldVal, this.myYOffset);
    }

    @Override
    public double scaleX(double x) {
        return (int)(x * this.myScaleX + this.myXOffset);
    }

    @Override
    public double scaleX(Point2D p) {
        return this.scaleX(p.getX());
    }

    @Override
    public double scaleY(double y) {
        if (this.myInvertY) {
            y = 1.0 - y;
        }
        return (int)(y * this.myScaleY + this.myYOffset);
    }

    @Override
    public double scaleY(Point2D p) {
        return this.scaleY(p.getY());
    }

    @Override
    public double unscaleX(double x) {
        return (x - this.myXOffset) / this.myScaleX;
    }

    @Override
    public double unscaleX(Point2D p) {
        return this.unscaleX(p.getX());
    }

    @Override
    public double unscaleY(double y) {
        double dY = (y - this.myYOffset) / this.myScaleY;
        if (this.myInvertY) {
            dY = 1.0 - dY;
        }
        return dY;
    }

    @Override
    public double unscaleY(Point2D p) {
        return this.unscaleY(p.getY());
    }
}

