/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.lifecycle;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.RepaintManager;
import javax.swing.table.DefaultTableModel;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.ManagedService;
import org.rwshop.swing.common.InnerScrollPaneWheelListener;
import org.rwshop.swing.common.lifecycle.DependencyListPanel;

public class ManagedServicePanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ManagedServicePanel.class.getName());
    private ManagedService<?> myService;
    private ServiceChangeListener myServiceChangeListener;
    private boolean myPropertiesVisible;
    private boolean myDependenciesVisible;
    private JButton btnDispose;
    private JButton btnRegister;
    private JButton btnUnregister;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JLabel lblDependencies;
    private JLabel lblDependencyCount;
    private JLabel lblRegistrationProperties;
    private JLabel lblStatus;
    private JTextArea lblType;
    private JPanel pnlButtons;
    private JPanel pnlCollapsable;
    private DependencyListPanel pnlDependencyList;
    private JPanel pnlDepsCollapse;
    private JPanel pnlProperties;
    private JPanel pnlPropsCollapse;
    private JPanel pnlTitle;
    private JTable tblProperties;

    public ManagedServicePanel() {
        this.initComponents();
        this.pnlDependencyList.setLayout(new BoxLayout(this.pnlDependencyList, 1));
        this.myServiceChangeListener = new ServiceChangeListener();
        this.myPropertiesVisible = true;
        this.tblProperties.setTableHeader(null);
        this.lblType.setOpaque(false);
        this.jScrollPane2.setOpaque(false);
        this.jScrollPane2.getViewport().setOpaque(false);
        this.jScrollPane2.addMouseWheelListener(new InnerScrollPaneWheelListener());
    }

    public void setManagedService(ManagedService service) {
        if (this.myService == service) {
            this.updateServiceInfo();
            return;
        }
        if (this.myService != null) {
            this.myService.removePropertyChangeListener((PropertyChangeListener)this.myServiceChangeListener);
        }
        this.myService = service;
        this.updateServiceInfo();
        this.setVals();
        this.setDependencies();
        this.myService.addPropertyChangeListener((PropertyChangeListener)this.myServiceChangeListener);
        this.markRepaint();
    }

    private void updateServiceInfo() {
        this.updateRegistrationStatus();
        if (this.myService == null) {
            this.lblType.setText("--");
            this.lblDependencyCount.setText("(--)");
            return;
        }
        String names = "";
        for (String name : this.myService.getServiceClassNames()) {
            if (!names.isEmpty()) {
                names = names + "\n";
            }
            names = names + name;
        }
        this.lblType.setText(names);
    }

    private void setVals() {
        Properties props = this.myService.getRegistrationProperties();
        Object[][] objs = new Object[props.size()][2];
        int i = 0;
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            objs[i][0] = e.getKey();
            objs[i][1] = e.getValue();
            ++i;
        }
        this.tblProperties.setModel(new DefaultTableModel(objs, new String[]{"Property Name", "Value"}));
        int h = this.tblProperties.getRowCount() * (this.tblProperties.getRowHeight() + this.tblProperties.getRowMargin());
        Dimension dim = this.pnlProperties.getSize();
        dim.setSize(dim.width, h);
        Dimension dim2 = this.tblProperties.getSize();
        Dimension d2 = new Dimension(dim2.width, h);
        this.pnlProperties.setPreferredSize(d2);
    }

    private void setDependencies() {
        this.pnlDependencyList.clearDependencies();
        if (this.myService != null) {
            for (DependencyDescriptor dep : this.myService.getDependencies()) {
                Boolean status = this.myService.getDependencyStatus(dep.getDependencyName());
                this.pnlDependencyList.addDependency(dep, status);
            }
        }
        this.updateDependencyCount();
    }

    private void resizeDependencies() {
        Dimension d = this.pnlDependencyList.getDependenciesSize();
        this.pnlDependencyList.setPreferredSize(d);
    }

    private void updateDependencyStatus(String dependencyId) {
        if (dependencyId == null) {
            return;
        }
        Boolean status = this.myService == null ? null : Boolean.valueOf(this.myService.getDependencyStatus(dependencyId));
        this.pnlDependencyList.updateDependnecyStatus(dependencyId, status);
        this.updateDependencyCount();
    }

    private void updateDependencyCount() {
        if (this.myService == null) {
            this.lblDependencyCount.setText("(--/--)");
            return;
        }
        int total = this.myService.getDependencyCount();
        int available = this.myService.getAvailableDependencyCount();
        this.lblDependencyCount.setText("(" + available + "/" + total + ")");
    }

    private void updateRegistrationStatus() {
        if (this.myService == null) {
            this.btnRegister.setEnabled(false);
            this.btnUnregister.setEnabled(false);
            this.lblStatus.setText("--");
            return;
        }
        boolean registered = this.myService.isRegistered();
        boolean available = this.myService.isAvailable();
        if (registered) {
            this.btnRegister.setEnabled(false);
            this.btnUnregister.setEnabled(true);
            this.lblStatus.setText("Available");
        } else if (available) {
            this.btnRegister.setEnabled(true);
            this.btnUnregister.setEnabled(false);
            this.lblStatus.setText("Unregistered");
        } else {
            this.btnRegister.setEnabled(false);
            this.btnUnregister.setEnabled(false);
            this.lblStatus.setText("Unavailable");
        }
    }

    public PropertyChangeListener getServiceChangeListener() {
        return this.myServiceChangeListener;
    }

    private void markRepaint() {
        RepaintManager.currentManager(this).markCompletelyDirty(this);
    }

    private void initComponents() {
        this.pnlTitle = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblStatus = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lblType = new JTextArea();
        this.pnlCollapsable = new JPanel();
        this.pnlDepsCollapse = new JPanel();
        this.lblDependencies = new JLabel();
        this.lblDependencyCount = new JLabel();
        this.pnlDependencyList = new DependencyListPanel();
        this.pnlPropsCollapse = new JPanel();
        this.lblRegistrationProperties = new JLabel();
        this.pnlProperties = new JPanel();
        this.tblProperties = new JTable();
        this.pnlButtons = new JPanel();
        this.btnUnregister = new JButton();
        this.btnRegister = new JButton();
        this.btnDispose = new JButton();
        this.jLabel1.setText("Service Type:");
        this.lblStatus.setText("--");
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setViewportBorder(null);
        this.jScrollPane2.setOpaque(false);
        this.lblType.setColumns(20);
        this.lblType.setEditable(false);
        this.lblType.setLineWrap(true);
        this.lblType.setRows(1);
        this.lblType.setWrapStyleWord(true);
        this.lblType.setBorder(null);
        this.lblType.setOpaque(false);
        this.jScrollPane2.setViewportView(this.lblType);
        GroupLayout pnlTitleLayout = new GroupLayout(this.pnlTitle);
        this.pnlTitle.setLayout(pnlTitleLayout);
        pnlTitleLayout.setHorizontalGroup(pnlTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTitleLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus).addContainerGap()));
        pnlTitleLayout.setVerticalGroup(pnlTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 21, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1)));
        this.pnlDepsCollapse.setBorder(BorderFactory.createEtchedBorder());
        this.lblDependencies.setText("[-]Dependencies");
        this.lblDependencies.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManagedServicePanel.this.lblDependenciesMouseClicked(evt);
            }
        });
        this.lblDependencyCount.setText("(--/--)");
        this.lblDependencyCount.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManagedServicePanel.this.lblDependencyCountMouseClicked(evt);
            }
        });
        this.pnlDependencyList.setMaximumSize(new Dimension(175, 600));
        GroupLayout pnlDependencyListLayout = new GroupLayout(this.pnlDependencyList);
        this.pnlDependencyList.setLayout(pnlDependencyListLayout);
        pnlDependencyListLayout.setHorizontalGroup(pnlDependencyListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 175, Short.MAX_VALUE));
        pnlDependencyListLayout.setVerticalGroup(pnlDependencyListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout pnlDepsCollapseLayout = new GroupLayout(this.pnlDepsCollapse);
        this.pnlDepsCollapse.setLayout(pnlDepsCollapseLayout);
        pnlDepsCollapseLayout.setHorizontalGroup(pnlDepsCollapseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDepsCollapseLayout.createSequentialGroup().addComponent(this.lblDependencies).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDependencyCount).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.pnlDependencyList, -1, -1, Short.MAX_VALUE));
        pnlDepsCollapseLayout.setVerticalGroup(pnlDepsCollapseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDepsCollapseLayout.createSequentialGroup().addGroup(pnlDepsCollapseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDependencies).addComponent(this.lblDependencyCount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlDependencyList, -1, -1, Short.MAX_VALUE)));
        this.pnlPropsCollapse.setBorder(BorderFactory.createEtchedBorder());
        this.lblRegistrationProperties.setText("[-]Registration Properties");
        this.lblRegistrationProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManagedServicePanel.this.lblRegistrationPropertiesMouseClicked(evt);
            }
        });
        this.pnlProperties.setBorder(null);
        this.tblProperties.setBorder(null);
        this.tblProperties.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Property Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblProperties.setAutoResizeMode(3);
        this.tblProperties.setCellSelectionEnabled(true);
        this.tblProperties.setFillsViewportHeight(true);
        this.tblProperties.setMinimumSize(new Dimension(0, 0));
        this.tblProperties.getTableHeader().setReorderingAllowed(false);
        GroupLayout pnlPropertiesLayout = new GroupLayout(this.pnlProperties);
        this.pnlProperties.setLayout(pnlPropertiesLayout);
        pnlPropertiesLayout.setHorizontalGroup(pnlPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tblProperties, GroupLayout.Alignment.TRAILING, -1, 175, Short.MAX_VALUE));
        pnlPropertiesLayout.setVerticalGroup(pnlPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tblProperties, GroupLayout.Alignment.TRAILING, -1, 47, Short.MAX_VALUE));
        GroupLayout pnlPropsCollapseLayout = new GroupLayout(this.pnlPropsCollapse);
        this.pnlPropsCollapse.setLayout(pnlPropsCollapseLayout);
        pnlPropsCollapseLayout.setHorizontalGroup(pnlPropsCollapseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRegistrationProperties, -1, -1, Short.MAX_VALUE).addComponent(this.pnlProperties, -1, -1, Short.MAX_VALUE));
        pnlPropsCollapseLayout.setVerticalGroup(pnlPropsCollapseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPropsCollapseLayout.createSequentialGroup().addComponent(this.lblRegistrationProperties).addGap(8, 8, 8).addComponent(this.pnlProperties, -2, -1, -2)));
        GroupLayout pnlCollapsableLayout = new GroupLayout(this.pnlCollapsable);
        this.pnlCollapsable.setLayout(pnlCollapsableLayout);
        pnlCollapsableLayout.setHorizontalGroup(pnlCollapsableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlPropsCollapse, -1, -1, Short.MAX_VALUE).addComponent(this.pnlDepsCollapse, -1, -1, Short.MAX_VALUE));
        pnlCollapsableLayout.setVerticalGroup(pnlCollapsableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCollapsableLayout.createSequentialGroup().addComponent(this.pnlPropsCollapse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlDepsCollapse, -1, -1, Short.MAX_VALUE)));
        this.btnUnregister.setText("Unregister");
        this.btnUnregister.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagedServicePanel.this.btnUnregisterActionPerformed(evt);
            }
        });
        this.btnRegister.setText("Register");
        this.btnRegister.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagedServicePanel.this.btnRegisterActionPerformed(evt);
            }
        });
        this.btnDispose.setText("Dispose");
        this.btnDispose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagedServicePanel.this.btnDisposeActionPerformed(evt);
            }
        });
        GroupLayout pnlButtonsLayout = new GroupLayout(this.pnlButtons);
        this.pnlButtons.setLayout(pnlButtonsLayout);
        pnlButtonsLayout.setHorizontalGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlButtonsLayout.createSequentialGroup().addContainerGap().addGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRegister, -1, 86, Short.MAX_VALUE).addComponent(this.btnUnregister, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnDispose, -1, 86, Short.MAX_VALUE)).addContainerGap()));
        pnlButtonsLayout.setVerticalGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlButtonsLayout.createSequentialGroup().addComponent(this.btnRegister).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUnregister).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnDispose)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.pnlCollapsable, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlButtons, -2, -1, -2)).addComponent(this.pnlTitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCollapsable, -2, -1, -2).addComponent(this.pnlButtons, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnUnregisterActionPerformed(ActionEvent evt) {
        if (this.myService == null) {
            this.btnUnregister.setEnabled(false);
            this.btnRegister.setEnabled(false);
            return;
        }
        this.myService.setRegistrationEnabled(false);
    }

    private void btnRegisterActionPerformed(ActionEvent evt) {
        if (this.myService == null) {
            this.btnUnregister.setEnabled(false);
            this.btnRegister.setEnabled(false);
            return;
        }
        this.myService.setRegistrationEnabled(true);
    }

    private void lblRegistrationPropertiesMouseClicked(MouseEvent evt) {
        if (this.myPropertiesVisible) {
            this.lblRegistrationProperties.setText("[+]Registration Properties");
            this.myPropertiesVisible = false;
            this.pnlProperties.setVisible(false);
        } else {
            this.lblRegistrationProperties.setText("[-]Registration Properties");
            this.myPropertiesVisible = true;
            this.pnlProperties.setVisible(true);
        }
    }

    private void lblDependenciesMouseClicked(MouseEvent evt) {
        this.toggleDependenciesVisible();
    }

    private void lblDependencyCountMouseClicked(MouseEvent evt) {
        this.toggleDependenciesVisible();
    }

    private void btnDisposeActionPerformed(ActionEvent evt) {
        this.disposeService();
    }

    private void toggleDependenciesVisible() {
        if (this.myDependenciesVisible) {
            this.lblDependencies.setText("[+]Dependencies");
            this.myDependenciesVisible = false;
            this.pnlDependencyList.setVisible(false);
        } else {
            this.lblDependencies.setText("[-]Dependencies");
            this.myDependenciesVisible = true;
            this.pnlDependencyList.setVisible(true);
        }
    }

    private void disposeService() {
        this.myService.dispose();
    }

    class ServiceChangeListener
    implements PropertyChangeListener {
        ServiceChangeListener() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                return;
            }
            String name = evt.getPropertyName();
            if ("serviceChanged".equals(name)) {
                ManagedServicePanel.this.setManagedService((ManagedService)evt.getNewValue());
            } else if ("dependencyChanged".equals(name)) {
                Object obj = evt.getNewValue();
                if (!(obj instanceof String)) {
                    return;
                }
                ManagedServicePanel.this.updateServiceInfo();
                ManagedServicePanel.this.updateDependencyStatus((String)obj);
            }
        }
    }
}

