/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.lifecycle;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.osgi.ServiceClassListener;
import org.rwshop.swing.common.lifecycle.ManagedServicePanel;

public class ManagedServiceListPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ManagedServiceListPanel.class.getName());
    private Map<ManagedService, ManagedServicePanel> myPanelMap;
    private ManagedServiceListener myServiceChangeListener = new ManagedServiceListener(this);
    private ServiceClassListener<ManagedService> myServiceTracker;
    private List<String> myFilters;
    private Map<ManagedService, ManagedServicePanel> myFilteredCache;
    private boolean myClassNames;
    private boolean myPropertyKeys;
    private boolean myPropertyValues;
    private boolean myDependencies;

    public ManagedServiceListPanel() {
        this.myPanelMap = new HashMap<ManagedService, ManagedServicePanel>();
        this.setFilters("", true, true, true, true);
    }

    public void setBundleContext(BundleContext context) {
        this.initLayout();
        this.myServiceTracker = new ServiceClassListener(ManagedService.class, context, null);
        this.myServiceTracker.addPropertyChangeListener((PropertyChangeListener)this.myServiceChangeListener);
        this.myServiceTracker.start();
    }

    public void initLayout() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public synchronized void addService(ManagedService service) {
        if (service == null || this.myPanelMap.containsKey(service)) {
            return;
        }
        ManagedServicePanel panel = new ManagedServicePanel();
        panel.setVisible(false);
        panel.setManagedService(service);
        this.myPanelMap.put(service, panel);
        this.add(panel);
        this.resize(panel.getPreferredSize().height);
        panel.setVisible(true);
        this.filterCache();
    }

    private void resize(int heightChange) {
        Dimension prefSize = this.getPreferredSize();
        Dimension newSize = new Dimension(prefSize.width, prefSize.height + heightChange);
    }

    public synchronized void removeService(ManagedService service) {
        if (service == null) {
            return;
        }
        ManagedServicePanel panel = this.myPanelMap.remove(service);
        if (panel == null) {
            return;
        }
        this.myPanelMap.remove(service);
        this.remove(panel);
        this.resize(-panel.getPreferredSize().height);
        this.revalidate();
        this.repaint();
        this.refresh();
    }

    public synchronized void clearDependencies() {
        this.myPanelMap.clear();
        this.removeAll();
    }

    public synchronized void setFilters(String filterStr, boolean classNames, boolean propertyKeys, boolean propertyValues, boolean dependencies) {
        String[] filters;
        this.myFilters = new ArrayList<String>();
        this.myClassNames = classNames;
        this.myPropertyKeys = propertyKeys;
        this.myPropertyValues = propertyValues;
        this.myDependencies = dependencies;
        for (String s : filters = filterStr.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            this.myFilters.add(s);
        }
        this.filterCache();
    }

    private void filterCache() {
        if (this.myPanelMap == null) {
            return;
        }
        if (this.myFilters == null || this.myFilters.isEmpty()) {
            this.myFilteredCache = this.myPanelMap;
            this.refresh();
            return;
        }
        this.myFilteredCache = new HashMap<ManagedService, ManagedServicePanel>();
        for (ManagedService thals : this.myPanelMap.keySet()) {
            if (!this.filterList(thals)) continue;
            this.myFilteredCache.put(thals, this.myPanelMap.get(thals));
        }
        this.refresh();
    }

    private void refresh() {
        for (ManagedService ms : this.myPanelMap.keySet()) {
            if (this.myFilteredCache.containsKey(ms)) {
                this.myPanelMap.get(ms).setVisible(true);
                continue;
            }
            this.myPanelMap.get(ms).setVisible(false);
        }
        this.updateUI();
    }

    private boolean filterList(ManagedService thals) {
        Pattern p;
        if (this.myClassNames) {
            for (String s : thals.getServiceClassNames()) {
                for (String f : this.myFilters) {
                    Pattern p2 = Pattern.compile(".*" + f + ".*", 40);
                    if (s == null || !p2.matcher(s).matches()) continue;
                    return true;
                }
            }
        }
        if (this.myPropertyKeys) {
            for (String s : thals.getRegistrationProperties().stringPropertyNames()) {
                for (String f : this.myFilters) {
                    p = Pattern.compile(".*" + f + ".*", 40);
                    if (s == null || !p.matcher(s).matches()) continue;
                    return true;
                }
            }
        }
        if (this.myPropertyValues) {
            for (String s : thals.getRegistrationProperties().stringPropertyNames()) {
                for (String f : this.myFilters) {
                    p = Pattern.compile(".*" + f + ".*", 40);
                    if (thals.getRegistrationProperties().getProperty(s) == null || !p.matcher(thals.getRegistrationProperties().getProperty(s)).matches()) continue;
                    return true;
                }
            }
        }
        if (this.myDependencies) {
            for (DependencyDescriptor d : thals.getDependencies()) {
                for (String f : this.myFilters) {
                    p = Pattern.compile(".*" + f + ".*", 40);
                    if (d.getDependencyName() != null && p.matcher(d.getDependencyName()).matches()) {
                        return true;
                    }
                    if (d.getServiceFilter() == null || !p.matcher(d.getServiceFilter()).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    class ManagedServiceListener
    implements PropertyChangeListener {
        private Component myComp;

        public ManagedServiceListener(Component comp) {
            this.myComp = comp;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                theLogger.warning("Received null property change event.");
                return;
            }
            if (evt.getNewValue() == null || !(evt.getNewValue() instanceof ManagedService)) {
                theLogger.log(Level.WARNING, "Received property change with bad value: {0}", evt.getPropertyName());
                return;
            }
            if ("serviceAdded".equals(evt.getPropertyName())) {
                ManagedServiceListPanel.this.addService((ManagedService)evt.getNewValue());
            } else if ("serviceRemoved".equals(evt.getPropertyName())) {
                ManagedServiceListPanel.this.removeService((ManagedService)evt.getNewValue());
            }
        }
    }
}

