/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.lifecycle;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.rwshop.swing.common.lifecycle.DependencyPanel;

public class DependencyListPanel
extends JPanel {
    private Map<String, DependencyPanel> myPanelMap = new HashMap<String, DependencyPanel>();

    public void addDependency(DependencyDescriptor dep, Boolean status) {
        if (dep == null) {
            throw new NullPointerException();
        }
        if (this.myPanelMap.containsKey(dep.getDependencyName())) {
            return;
        }
        DependencyPanel panel = new DependencyPanel();
        panel.setDependency(dep, status);
        this.myPanelMap.put(dep.getDependencyName(), panel);
        this.add(panel);
    }

    public Dimension getDependenciesSize() {
        int height = 0;
        for (DependencyPanel p : this.myPanelMap.values()) {
            height += p.getPreferredSize().height;
        }
        Dimension d = new Dimension(this.getPreferredSize().width, height);
        return d;
    }

    public void removeDependency(DependencyDescriptor dep) {
        if (dep == null) {
            throw new NullPointerException();
        }
        DependencyPanel panel = this.myPanelMap.remove(dep.getDependencyName());
        if (panel == null) {
            return;
        }
        this.myPanelMap.remove(dep.getDependencyName());
        this.remove(panel);
    }

    public void updateDependnecyPanel(DependencyDescriptor dep, Boolean status) {
        if (dep == null) {
            throw new NullPointerException();
        }
        DependencyPanel panel = this.myPanelMap.get(dep.getDependencyName());
        if (panel == null) {
            return;
        }
        panel.updateDisplay(status);
    }

    public boolean hasDependency(String depId) {
        if (depId == null) {
            return false;
        }
        return this.myPanelMap.containsKey(depId);
    }

    public void updateDependnecyStatus(String depId, Boolean status) {
        if (depId == null) {
            throw new NullPointerException();
        }
        DependencyPanel panel = this.myPanelMap.get(depId);
        if (panel == null) {
            return;
        }
        panel.updateStatus(status);
        RepaintManager.currentManager(this).markCompletelyDirty(panel);
    }

    public void clearDependencies() {
        this.myPanelMap.clear();
        this.removeAll();
    }
}

