/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.config.Configuration;

public class ConfigurationPanel
extends JPanel {
    private Configuration<String> myConfig;
    private static final Logger theLogger = Logger.getLogger(ConfigurationPanel.class.getName());
    private GridBagConstraints myConstraints;
    private JTextField jTextField1;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private List<String> myFilters;
    private List<String> myFilteredKeys;
    private boolean myKeys;
    private boolean myValues;
    private String myFilterStr;

    public ConfigurationPanel() {
        this.initComponents();
        this.myConstraints = new GridBagConstraints();
        this.myConstraints.fill = 2;
    }

    public void setConfig(Configuration<String> config, boolean inner) {
        this.myConstraints.gridy = 0;
        this.removeAll();
        this.myConfig = config;
        this.setLayout(new GridBagLayout());
        this.setFilters("", true, true);
        this.jTextField1 = new JTextField();
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ConfigurationPanel.this.jTextField1KeyReleased(evt);
            }
        });
        this.jTextField1.setDropTarget(null);
        this.jCheckBox1 = new JCheckBox("Keys", true);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox2 = new JCheckBox("Values", true);
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        if (!inner) {
            this.myConstraints.gridwidth = 2;
            this.myConstraints.gridx = 0;
            this.myConstraints.weightx = 1.0;
            this.add((Component)this.jTextField1, this.myConstraints);
            this.myConstraints.weightx = 0.0;
            this.myConstraints.gridwidth = 1;
            this.myConstraints.gridy = 1;
            this.add((Component)this.jCheckBox1, this.myConstraints);
            this.myConstraints.gridx = 1;
            this.add((Component)this.jCheckBox2, this.myConstraints);
            this.myConstraints.gridx = 0;
            this.myConstraints.gridy = 2;
        } else {
            this.myConstraints.gridx = 0;
            this.myConstraints.gridy = 0;
            this.myConstraints.weightx = 0.0;
            this.myConstraints.gridwidth = 1;
        }
        if (config == null) {
            return;
        }
        for (String s : config.getKeySet()) {
            JLabel label = new JLabel(s);
            label.setName(s);
            this.myConstraints.gridx = 0;
            this.myConstraints.weightx = 0.0;
            this.add((Component)label, this.myConstraints);
            this.myConstraints.gridx = 1;
            this.myConstraints.weightx = 1.0;
            if (Configuration.class.isAssignableFrom(config.getPropertyClass((Object)s))) {
                this.addConfigurationPanel(s);
            } else if (!this.isParseable(config.getPropertyClass((Object)s)) || config.getPropertySetter((Object)s) == null) {
                this.addReadOnlyField(s);
            } else {
                this.addEditor(s);
            }
            ++this.myConstraints.gridy;
        }
        this.revalidate();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    public Configuration getConfig() {
        return this.myConfig;
    }

    private void pushValue(String key, String val) {
        Listener setter = this.myConfig.getPropertySetter((Object)key);
        Class cls = this.myConfig.getPropertyClass((Object)key);
        try {
            Object parsedVal = this.parseValue(cls, val);
            setter.handleEvent(parsedVal);
        }
        catch (Exception e) {
            String message = "Failed to set " + val + " on " + key;
            String longMessage = message + ":\n\n" + e.getMessage();
            theLogger.log(Level.SEVERE, "{0}.", message);
            theLogger.log(Level.SEVERE, e.getMessage());
            JOptionPane.showMessageDialog(this, longMessage, "Error", 0);
        }
    }

    private boolean isParseable(Class cls) {
        if (Integer.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Long.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Short.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Byte.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Float.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Double.class.isAssignableFrom(cls)) {
            return true;
        }
        return String.class.isAssignableFrom(cls);
    }

    private Object parseValue(Class cls, String val) {
        if (Integer.class.isAssignableFrom(cls)) {
            return Integer.parseInt(val);
        }
        if (Long.class.isAssignableFrom(cls)) {
            return Long.parseLong(val);
        }
        if (Short.class.isAssignableFrom(cls)) {
            return Short.parseShort(val);
        }
        if (Byte.class.isAssignableFrom(cls)) {
            return Byte.parseByte(val);
        }
        if (Float.class.isAssignableFrom(cls)) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Double.class.isAssignableFrom(cls)) {
            return Double.parseDouble(val);
        }
        if (String.class.isAssignableFrom(cls)) {
            return val;
        }
        throw new IllegalArgumentException(val);
    }

    private void addConfigurationPanel(String s) {
        Configuration newConfig = (Configuration)this.myConfig.getPropertyValue((Object)s);
        ConfigurationPanel panel = new ConfigurationPanel();
        if (newConfig.equals(this.myConfig)) {
            JTextField field = new JTextField("This configuration");
            field.setName(s);
            field.setEditable(false);
            this.add((Component)field, this.myConstraints);
            theLogger.log(Level.WARNING, "Cannot add a configuration to itself.");
            return;
        }
        panel.setName(s);
        panel.setConfig((Configuration<String>)newConfig, true);
        this.add((Component)panel, this.myConstraints);
    }

    private void addReadOnlyField(String s) {
        JTextField field = this.myConfig.getPropertyValue((Object)s) != null ? new JTextField(this.myConfig.getPropertyValue((Object)s).toString()) : new JTextField("null");
        field.setEditable(false);
        field.setName(s);
        field.setDropTarget(null);
        this.add((Component)field, this.myConstraints);
    }

    private void addEditor(String key) {
        final JTextField field = new JTextField();
        final String finalKey = key;
        final Configuration<String> fConfig = this.myConfig;
        if (this.myConfig.getPropertyValue((Object)key) != null) {
            field.setText(this.myConfig.getPropertyValue((Object)key).toString());
        }
        field.setName(key);
        field.setDropTarget(null);
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    String val = field.getText();
                    ConfigurationPanel.this.pushValue(finalKey, val);
                    ConfigurationPanel.this.filterCache();
                }
            }
        });
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                String val = field.getText();
                ConfigurationPanel.this.pushValue(finalKey, val);
                ConfigurationPanel.this.filterCache();
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        Notifier notifier = this.myConfig.getPropertyNotifier((Object)key);
        notifier.addListener(new Listener(){

            public void handleEvent(Object input) {
                field.setText(fConfig.getPropertyValue((Object)finalKey).toString());
                ConfigurationPanel.this.filterCache();
            }
        });
        this.add((Component)field, this.myConstraints);
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        this.setFilters(this.jTextField1.getText(), this.jCheckBox1.isSelected(), this.jCheckBox2.isSelected());
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.setFilters(this.jTextField1.getText(), this.jCheckBox1.isSelected(), this.jCheckBox2.isSelected());
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.setFilters(this.jTextField1.getText(), this.jCheckBox1.isSelected(), this.jCheckBox2.isSelected());
    }

    public void setFilters(String filterStr, boolean keys, boolean values) {
        String[] filters;
        this.myFilters = new ArrayList<String>();
        this.myFilterStr = filterStr;
        this.myKeys = keys;
        this.myValues = values;
        for (String s : filters = filterStr.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            this.myFilters.add(s);
        }
        this.filterCache();
    }

    private void filterCache() {
        if (this.myConfig == null || this.myConfig.getKeySet().isEmpty()) {
            return;
        }
        if (this.myFilters == null || this.myFilters.isEmpty()) {
            this.myFilteredKeys = new ArrayList<String>();
            for (String key : this.myConfig.getKeySet()) {
                this.myFilteredKeys.add(key);
            }
            this.refresh();
            return;
        }
        this.myFilteredKeys = new ArrayList<String>();
        for (String thals : this.myConfig.getKeySet()) {
            if (!this.filterList(thals)) continue;
            this.myFilteredKeys.add(thals);
        }
        this.refresh();
    }

    public boolean refresh() {
        boolean anything = false;
        for (Component comp : this.getComponents()) {
            if (comp == null || comp == this.jTextField1 || comp == this.jCheckBox1 || comp == this.jCheckBox2) continue;
            if (ConfigurationPanel.class.isAssignableFrom(comp.getClass())) {
                ConfigurationPanel inner = (ConfigurationPanel)comp;
                inner.setFilters(this.myFilterStr, this.myKeys, this.myValues);
                boolean keepInner = inner.refresh();
                comp.setVisible(keepInner);
                if (keepInner) continue;
            }
            if (this.myFilteredKeys.contains(comp.getName())) {
                comp.setVisible(true);
                anything = true;
                continue;
            }
            comp.setVisible(false);
        }
        this.revalidate();
        try {
            ((JFrame)this.getTopLevelAncestor()).pack();
        }
        catch (Exception e) {
            theLogger.log(Level.WARNING, e.getMessage());
        }
        return anything;
    }

    private boolean filterList(String thals) {
        Pattern p;
        if (this.myKeys) {
            for (String f : this.myFilters) {
                p = Pattern.compile(".*" + f + ".*", 40);
                if (!p.matcher(thals).matches()) continue;
                return true;
            }
        }
        if (this.myValues) {
            for (String f : this.myFilters) {
                p = Pattern.compile(".*" + f + ".*", 40);
                if (!p.matcher(this.myConfig.getPropertyValue((Object)thals).toString()).matches()) continue;
                return true;
            }
        }
        if (Configuration.class.isAssignableFrom(this.myConfig.getPropertyClass((Object)thals))) {
            Configuration newConfig = (Configuration)this.myConfig.getPropertyValue((Object)thals);
            if (newConfig.equals(this.myConfig)) {
                return false;
            }
            for (Component comp : this.getComponents()) {
                ConfigurationPanel inner;
                if (!ConfigurationPanel.class.isAssignableFrom(comp.getClass()) || (inner = (ConfigurationPanel)comp).getConfig() != newConfig) continue;
                inner.setFilters(this.myFilterStr, this.myKeys, this.myValues);
                return inner.refresh();
            }
        }
        return false;
    }
}

