/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableHelper {
    public static void setColumnCheckBoxIcons(TableColumn tc, Icon icon, Icon selIcon, String tooltip) {
        CheckBoxIconCellRenderer tcr = new CheckBoxIconCellRenderer(icon, selIcon, tooltip);
        TableCellEditor tce = TableHelper.buildCheckBoxCellEditor(icon, selIcon, tooltip);
        tc.setCellRenderer(tcr);
        tc.setCellEditor(tce);
    }

    public static void setColumnWidth(TableColumn tc, int width) {
        tc.setPreferredWidth(width);
        tc.setWidth(width);
    }

    public static TableCellEditor buildCheckBoxCellEditor(Icon icon, Icon selIcon, String tooltip) {
        JCheckBox cb = new JCheckBox();
        TableHelper.makeCellCheckBox(cb, icon, selIcon, tooltip);
        return new DefaultCellEditor(cb);
    }

    private static void makeCellCheckBox(JCheckBox cb, Icon icon, Icon selIcon, String tooltip) {
        cb.setHorizontalAlignment(0);
        if (icon != null) {
            cb.setIcon(icon);
        }
        if (selIcon != null) {
            cb.setSelectedIcon(selIcon);
        }
        cb.setOpaque(true);
        cb.setToolTipText(tooltip);
    }

    public static class CheckBoxIconCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxIconCellRenderer(Icon icon, Icon selIcon, String tooltip) {
            TableHelper.makeCellCheckBox(this, icon, selIcon, tooltip);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

