/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class ResizableGrid
extends JPanel
implements ComponentListener {
    protected CoordinateScalar myScalar;
    private int myKeyHeight = 30;
    private int myKeyPlacement;

    public ResizableGrid() {
        this.initComponents();
        this.addComponentListener(this);
    }

    public void init(CoordinateScalar s, int keyHeight) {
        this.myKeyHeight = keyHeight;
        this.myScalar = s;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawGridLines(g);
        this.drawTimelineKey(g);
    }

    private void drawTimelineKey(Graphics g) {
        if (this.myScalar == null) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.black);
        double tStep = this.calcStep();
        double max = this.myScalar.unscaleX(w);
        double t = 0.0;
        double i = 0.0;
        while (t < max) {
            int l = 5;
            int x = (int)this.myScalar.scaleX(t);
            if (i % 5.0 == 0.0 && i != 0.0) {
                g.setColor(Color.lightGray);
                g.drawLine(x, 0, x, h - this.myKeyHeight);
                g.setColor(Color.black);
            }
            if (i % 20.0 == 0.0) {
                l = 15;
                DecimalFormat nf = new DecimalFormat("0.000");
                g.drawString(nf.format(t / 1000.0), x, h - 17);
            } else if (i % 10.0 == 0.0) {
                l = 11;
            } else if (i % 5.0 == 0.0) {
                l = 8;
            }
            if (i != 0.0) {
                g.drawLine(x, h, x, h - l);
            }
            t += tStep;
            i += 1.0;
        }
    }

    private double calcStep() {
        double log;
        double t = this.myScalar.unscaleX(5.0);
        double n1 = log = Math.log10(t);
        double n2 = log - 0.301029996;
        double n5 = log - 0.698970004;
        n1 = Math.round(n1);
        n2 = Math.round(n2);
        n5 = Math.round(n5);
        double t1 = Math.pow(10.0, n1);
        double t2 = 2.0 * Math.pow(10.0, n2);
        double t5 = 5.0 * Math.pow(10.0, n5);
        n1 = Math.abs(t1 - t);
        n2 = Math.abs(t2 - t);
        n5 = Math.abs(t5 - t);
        if (n1 < n2 && n1 < n5) {
            return t1;
        }
        if (n2 < n1 && n2 < n5) {
            return t2;
        }
        return t5;
    }

    private void drawGridLines(Graphics g) {
        if (this.myScalar == null) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            float y = (float)i / 16.0f;
            int h = (int)this.myScalar.scaleY(y);
            if (y == 0.5f) {
                g.setColor(Color.black);
                g.drawLine(0, h - 1, this.getWidth(), h - 1);
            } else if (y == 0.75f || y == 0.25f) {
                g.setColor(Color.darkGray);
            } else {
                g.setColor(Color.lightGray);
            }
            g.drawLine(0, h, this.getWidth(), h);
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.adjustScalar();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.adjustScalar();
    }

    private void adjustScalar() {
        if (this.myScalar == null) {
            return;
        }
        this.myScalar.setScaleY(this.getHeight() - this.myKeyHeight);
    }
}

