/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.playable.PlayableListener;
import org.robokind.api.common.utils.TimeUtils;
import org.rwshop.swing.common.utils.SettingsRepository;

public class PlayControlPanel
extends JPanel
implements PlayableListener {
    private static Icon[] theIcons = null;
    private Playable myPlayable;
    private JButton myPlayButton;
    private JButton myStopButton;

    private static Icon[] getIcons() {
        if (theIcons == null) {
            theIcons = SettingsRepository.getPlayIcons24();
        }
        return theIcons;
    }

    public PlayControlPanel() {
        this.initComponents();
        this.myPlayButton.setEnabled(false);
        this.myStopButton.setEnabled(false);
        if (!SettingsRepository.isInitialized()) {
            return;
        }
        Icon[] icons = PlayControlPanel.getIcons();
        this.myPlayButton.setIcon(icons[0]);
        this.myStopButton.setIcon(icons[3]);
    }

    public void setPlayable(Playable playable) {
        if (this.myPlayable != null) {
            this.myPlayable.removePlayableListener((PlayableListener)this);
        }
        this.myPlayable = playable;
        if (this.myPlayable != null) {
            this.myPlayable.addPlayableListener((PlayableListener)this);
        }
        this.updatePanel();
    }

    public void updatePanel() {
        Icon play;
        boolean enabled = this.myPlayable != null;
        this.myPlayButton.setEnabled(enabled);
        this.myStopButton.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        PlayState state = this.myPlayable.getPlayState();
        this.myStopButton.setEnabled(state != PlayState.COMPLETED && state != PlayState.PENDING && state != PlayState.STOPPED);
        Icon[] icons = PlayControlPanel.getIcons();
        switch (state) {
            case PENDING: 
            case COMPLETED: 
            case STOPPED: {
                play = icons[0];
                break;
            }
            case RUNNING: {
                play = icons[1];
                break;
            }
            case PAUSED: {
                play = icons[2];
                break;
            }
            default: {
                play = null;
            }
        }
        if (play != null) {
            this.myPlayButton.setIcon(play);
        }
    }

    private void initComponents() {
        this.myPlayButton = new JButton();
        this.myStopButton = new JButton();
        this.myPlayButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.myPlayButton.setMargin(null);
        this.myPlayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayControlPanel.this.myPlayButtonActionPerformed(evt);
            }
        });
        this.myStopButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.myStopButton.setIconTextGap(0);
        this.myStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayControlPanel.this.myStopButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myPlayButton, -2, 33, -2).addGap(2, 2, 2).addComponent(this.myStopButton, -2, 33, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myStopButton, -2, 33, -2).addComponent(this.myPlayButton, -2, 33, -2));
    }

    private void myPlayButtonActionPerformed(ActionEvent evt) {
        if (this.myPlayable == null) {
            return;
        }
        PlayState state = this.myPlayable.getPlayState();
        switch (state) {
            case PENDING: 
            case COMPLETED: 
            case STOPPED: {
                this.myPlayable.start(TimeUtils.now());
                break;
            }
            case RUNNING: {
                this.myPlayable.pause(TimeUtils.now());
                break;
            }
            case PAUSED: {
                this.myPlayable.resume(TimeUtils.now());
            }
        }
    }

    private void myStopButtonActionPerformed(ActionEvent evt) {
        if (this.myPlayable == null) {
            return;
        }
        this.myPlayable.stop(TimeUtils.now());
    }

    public void playStateChanged(PlayState prev, PlayState state, long time) {
        this.updatePanel();
    }
}

