/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.lang.StringUtils;

public class HistoricalComboBoxModel
extends DefaultComboBoxModel {
    private List<String> myEntries;
    private String selected;
    private Preferences myPrefs;
    private String myKey;
    private String myDefVal;

    public HistoricalComboBoxModel(String node, String key, String defVal) {
        this.myPrefs = Preferences.userRoot().node(node);
        this.myKey = key;
        this.myDefVal = defVal;
        String histString = this.myPrefs.get(this.myKey, this.myDefVal);
        String[] history = histString.split("\u00a4");
        this.myEntries = new ArrayList<String>();
        this.myEntries.addAll(Arrays.asList(history));
        this.selected = !this.myEntries.isEmpty() ? this.myEntries.get(0) : null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!this.myEntries.contains(anItem.toString())) {
            this.myEntries.add(anItem.toString());
            String history = StringUtils.join(this.myEntries, (String)"\u00a4");
            this.myPrefs.put(this.myKey, history);
        }
        this.selected = anItem.toString();
        this.fireContentsChanged(this, 0, this.myEntries.size() - 1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        return this.myEntries.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.myEntries.isEmpty()) {
            return null;
        }
        return this.myEntries.get(index);
    }

    public void clear() {
        this.myEntries = new ArrayList<String>();
        this.selected = "";
        this.myPrefs.put(this.myKey, this.myDefVal);
    }

    public void deleteSelected() {
        this.myEntries.remove(this.selected);
        this.selected = !this.myEntries.isEmpty() ? this.myEntries.get(0) : null;
        String history = StringUtils.join(this.myEntries, (String)"\u00a4");
        this.myPrefs.put(this.myKey, history);
        this.fireContentsChanged(this, 0, this.myEntries.size() - 1);
    }
}

