/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.rwshop.swing.common.utils.SettingsRepository;

public class ComponentHeaderPanel
extends JPanel {
    private JButton myCloseButton;
    private JLabel myHeaderLaber;
    private JLabel myHeaderStatus;
    private JPanel myHeaderTextPanel;
    private JLabel myIcon;
    private JLabel myTitle;
    private JLabel myTitleMinor;

    public ComponentHeaderPanel() {
        this.initComponents();
        if (!SettingsRepository.isInitialized()) {
            return;
        }
        Icon[] icons = SettingsRepository.getDefaultHeaderIcons();
        this.myIcon.setIcon(icons[0]);
        this.myCloseButton.setIcon(icons[1]);
        this.myCloseButton.setRolloverIcon(icons[2]);
        this.myCloseButton.setSelectedIcon(icons[3]);
        this.myCloseButton.setRolloverEnabled(true);
    }

    public void setTitle(String major, String minor) {
        this.myTitle.setText(major);
        if (minor == null || minor.isEmpty()) {
            this.myTitleMinor.setText("");
        } else {
            this.myTitleMinor.setText(" - " + minor);
        }
    }

    public void setLabel(String label) {
        if (label == null || label.isEmpty()) {
            this.myHeaderLaber.setText("");
        } else {
            this.myHeaderLaber.setText("(" + label + ")");
        }
    }

    public void setStatus(String status) {
        if (status == null || status.isEmpty()) {
            this.myHeaderStatus.setText(" ");
        } else {
            this.myHeaderStatus.setText(status + " ");
        }
    }

    public void setIcon(Icon icon) {
        this.myIcon.setIcon(icon);
    }

    public void setCloseIcons(Icon icon, Icon hover, Icon select) {
        this.myCloseButton.setIcon(icon);
        this.myCloseButton.setRolloverIcon(hover);
        this.myCloseButton.setSelectedIcon(select);
        this.myCloseButton.setRolloverEnabled(hover == null && select == null);
    }

    public void addCloseActionListener(ActionListener listener) {
        this.myCloseButton.addActionListener(listener);
    }

    public void removeCloseActionListener(ActionListener listener) {
        this.myCloseButton.removeActionListener(listener);
    }

    private void initComponents() {
        this.myIcon = new JLabel();
        this.myCloseButton = new JButton();
        this.myHeaderTextPanel = new JPanel();
        this.myTitle = new JLabel();
        this.myTitleMinor = new JLabel();
        this.myHeaderStatus = new JLabel();
        this.myHeaderLaber = new JLabel();
        this.myIcon.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        this.myIcon.setMaximumSize(new Dimension(16, 16));
        this.myIcon.setMinimumSize(new Dimension(16, 16));
        this.myIcon.setPreferredSize(new Dimension(16, 16));
        this.myIcon.setRequestFocusEnabled(false);
        this.myCloseButton.setToolTipText("Close");
        this.myCloseButton.setBorder(null);
        this.myCloseButton.setBorderPainted(false);
        this.myCloseButton.setContentAreaFilled(false);
        this.myCloseButton.setFocusable(false);
        this.myCloseButton.setHideActionText(true);
        this.myCloseButton.setMargin(new Insets(0, 0, 0, 0));
        this.myCloseButton.setMaximumSize(new Dimension(16, 16));
        this.myCloseButton.setMinimumSize(new Dimension(16, 16));
        this.myCloseButton.setPreferredSize(new Dimension(16, 16));
        this.myHeaderTextPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.myTitle.setFont(new Font("Tahoma", 1, 11));
        this.myTitle.setText("Title");
        this.myTitle.setIconTextGap(0);
        this.myTitleMinor.setText("- Minor");
        this.myHeaderStatus.setFont(new Font("Tahoma", 2, 11));
        this.myHeaderStatus.setText("Status ");
        this.myHeaderLaber.setText("(Label)");
        GroupLayout myHeaderTextPanelLayout = new GroupLayout(this.myHeaderTextPanel);
        this.myHeaderTextPanel.setLayout(myHeaderTextPanelLayout);
        myHeaderTextPanelLayout.setHorizontalGroup(myHeaderTextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myHeaderTextPanelLayout.createSequentialGroup().addComponent(this.myTitle).addGap(2, 2, 2).addComponent(this.myTitleMinor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 302, Short.MAX_VALUE).addComponent(this.myHeaderLaber).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myHeaderStatus)));
        myHeaderTextPanelLayout.setVerticalGroup(myHeaderTextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myHeaderTextPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myHeaderStatus).addComponent(this.myHeaderLaber).addComponent(this.myTitle).addComponent(this.myTitleMinor)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myIcon, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myHeaderTextPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCloseButton, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myIcon, -2, 16, -2).addComponent(this.myCloseButton, -2, -1, -2).addComponent(this.myHeaderTextPanel, -2, -1, -2));
    }
}

