/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.scroll;

import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EndlessScrollListener
implements AdjustmentListener,
ComponentListener {
    private boolean myStartReset = true;
    private Integer myStartValue = null;
    private JPanel myPanel;
    private int myAdjustRate = 15;

    public EndlessScrollListener(int scrollRate) {
    }

    public void init(JPanel panel, JScrollPane pane) {
        this.myPanel = panel;
        pane.addComponentListener(this);
        pane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.resizePanel(0, this.myPanel.getPreferredSize().width);
    }

    public void setAdjustRate(int rate) {
        this.myAdjustRate = rate;
    }

    public int getAdjustRate() {
        return this.myAdjustRate;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.myPanel == null) {
            return;
        }
        int max = e.getAdjustable().getMaximum() - e.getAdjustable().getVisibleAmount();
        int val = e.getAdjustable().getValue();
        int extent = e.getAdjustable().getVisibleAmount();
        if (!e.getValueIsAdjusting()) {
            this.handleScrollEnd(e, max, val, extent);
        } else {
            this.handleDuringScroll(e, max, val, extent);
        }
    }

    private void handleScrollEnd(AdjustmentEvent e, int max, int val, int extent) {
        if (this.myStartValue != null && val < this.myStartValue) {
            int n = this.myPanel.getPreferredSize().width;
            this.resizePanel(n, extent);
        } else if (max - val < this.myAdjustRate) {
            int n = this.myPanel.getPreferredSize().width + this.myAdjustRate;
            this.resizePanel(n, extent);
        }
        this.myStartValue = val;
        this.myStartReset = true;
    }

    private void handleDuringScroll(AdjustmentEvent e, int max, int val, int extent) {
        if (max - val < this.myAdjustRate) {
            this.resizePanel(this.myPanel.getPreferredSize().width + this.myAdjustRate, extent);
        }
        if (this.myStartValue == null || this.myStartReset) {
            this.myStartValue = val;
            this.myStartReset = false;
        }
    }

    private void resizePanel(int size, int extent) {
        size = Math.max(size, extent + this.myAdjustRate);
        size = Math.max(size, this.myPanel.getMinimumSize().width);
        this.myPanel.setPreferredSize(new Dimension(size, this.myPanel.getPreferredSize().height));
        this.myPanel.revalidate();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.myPanel == null) {
            return;
        }
        this.resizePanel(0, e.getComponent().getPreferredSize().width);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

