/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.scroll;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelListener;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.robokind.api.animation.editor.AnimationEditor;
import org.rwshop.swing.animation.timeline.AnimationTimelinePanel;
import org.rwshop.swing.animation.timeline.scroll.EndlessScrollListener;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.LinkedScrollbarListener;
import org.rwshop.swing.common.scaling.ScalableComponent;
import org.rwshop.swing.common.scaling.ScalingManager;
import org.rwshop.swing.common.scaling.ScalingScrollWheelListener;
import org.rwshop.swing.common.scaling.ScrollingScalableComponent;

public class AnimationScrollPanel
extends JPanel {
    private AnimationEditor myController;
    private CoordinateScalar myScalar;
    private ScalingScrollWheelListener myScrollWheelListener;
    private EndlessScrollListener myScrollBarListener;
    private ScrollingScalableComponent myScalingComp;
    public boolean myInitFlag = false;
    private LinkedScrollbarListener myLinkedScrollListener;
    private AnimationTimelinePanel myPanel;
    private JScrollPane myScrollPane;

    public AnimationScrollPanel() {
        this.initComponents();
        this.myScrollBarListener = new EndlessScrollListener(15);
        this.myScrollWheelListener = new ScalingScrollWheelListener();
        this.myScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.myScalingComp = new ScrollingScalableComponent((ScalableComponent)this.myPanel, this.myScrollPane);
    }

    public void init(ScalingManager scalingManager) {
        this.myLinkedScrollListener = new LinkedScrollbarListener(0, scalingManager);
        scalingManager.addComponent((ScalableComponent)this.myScalingComp);
        this.myScrollBarListener.init((JPanel)((Object)this.myPanel), this.myScrollPane);
        this.myScrollWheelListener.init(this.myScrollPane, scalingManager);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener((AdjustmentListener)this.myLinkedScrollListener);
        this.myPanel.addMouseWheelListener((MouseWheelListener)this.myScrollWheelListener);
        this.myScalar = scalingManager.getScalar();
        this.myInitFlag = true;
    }

    public void setController(AnimationEditor controller) {
        if (!this.myInitFlag) {
            throw new IllegalStateException("Panel must be initialized before using.");
        }
        this.myController = controller;
        this.myPanel.setController(controller);
        this.resetSize();
    }

    public void resetSize() {
        if (!this.myInitFlag) {
            return;
        }
        int w = this.getParent().getWidth() + 1;
        if (w > 1) {
            this.myPanel.setPreferredSize(new Dimension(w, this.myPanel.getPreferredSize().height));
        }
        if (this.myController != null) {
            double length = this.myController.getEnd();
            double width = this.getWidth() - 20;
            double scaleX = 0.2;
            if (width > 0.0 && length > 0.0) {
                scaleX = width / length;
            }
            this.myScalar.setScaleX(scaleX);
        }
    }

    private void initComponents() {
        this.myScrollPane = new JScrollPane();
        this.myPanel = new AnimationTimelinePanel();
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.setVerticalScrollBarPolicy(21);
        GroupLayout myPanelLayout = new GroupLayout((Container)((Object)this.myPanel));
        this.myPanel.setLayout(myPanelLayout);
        myPanelLayout.setHorizontalGroup(myPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        myPanelLayout.setVerticalGroup(myPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        this.myScrollPane.setViewportView((Component)((Object)this.myPanel));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myScrollPane, -1, 56, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myScrollPane, -1, 57, Short.MAX_VALUE));
    }
}

