/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.range;

import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import org.robokind.api.animation.editor.features.AnimationTimeRange;
import org.rwshop.swing.animation.menus.MenuProvider;
import org.rwshop.swing.animation.menus.UIMenuItem;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimeRangeMenuProvider
implements MenuProvider {
    private AnimationTimeRange myTimeRange;
    private CoordinateScalar myScalar;

    public void setAnimationTimeRange(AnimationTimeRange timeRange) {
        this.myTimeRange = timeRange;
    }

    public void setScalar(CoordinateScalar scalar) {
        this.myScalar = scalar;
    }

    @Override
    public JMenu getContextSubMenu(MouseEvent e) {
        if (this.myTimeRange == null || this.myScalar == null || e == null) {
            return null;
        }
        int x = e.getX();
        long time = (long)this.myScalar.unscaleX((double)x);
        JMenu menu = new JMenu("Start/Stop Times");
        menu.add(this.getStart(time));
        menu.add(this.getStop(time));
        UIMenuItem item = this.getPlay(time);
        if (item != null) {
            menu.add(item);
        }
        return menu;
    }

    private UIMenuItem getStart(long time) {
        AnimationTimeRange.SetStartAction startAction = this.myTimeRange.getSetStartAction(Long.valueOf(time));
        return new UIMenuItem("Set Start Time", (ActionListener)startAction);
    }

    private UIMenuItem getStop(long time) {
        AnimationTimeRange.SetStopAction startAction = this.myTimeRange.getSetStopAction(Long.valueOf(time));
        return new UIMenuItem("Set Stop Time", (ActionListener)startAction);
    }

    private UIMenuItem getPlay(long time) {
        AnimationTimeRange.PlayAction startAction = this.myTimeRange.getPlayAction(Long.valueOf(time));
        if (startAction == null) {
            return null;
        }
        return new UIMenuItem("Play Range", (ActionListener)startAction);
    }
}

