/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.range;

import java.awt.Color;
import java.awt.Graphics;
import org.robokind.api.animation.editor.features.AnimationTimeRange;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimeRangeLayer
implements DrawableLayer {
    private AnimationTimeRange myTimeRange;
    private CoordinateScalar myScalar;
    private Color myStartColor = Color.GREEN;
    private Color myStopColor = Color.RED;

    public void setAnimationTimeRange(AnimationTimeRange startStop) {
        this.myTimeRange = startStop;
    }

    public void setScalar(CoordinateScalar s) {
        this.myScalar = s;
    }

    public void setStartColor(Color col) {
        if (col == null) {
            return;
        }
        this.myStartColor = col;
    }

    public void setStopColor(Color col) {
        if (col == null) {
            return;
        }
        this.myStopColor = col;
    }

    public void paint(Graphics g) {
        if (this.myTimeRange == null || this.myScalar == null) {
            return;
        }
        Long start = this.myTimeRange.getStartTime();
        Long stop = this.myTimeRange.getStopTime();
        this.drawLine(g, start, this.myStartColor);
        this.drawLine(g, stop, this.myStopColor);
    }

    private void drawLine(Graphics g, Long time, Color col) {
        if (time == null) {
            return;
        }
        int x = (int)this.myScalar.scaleX((double)time.longValue());
        int y0 = (int)this.myScalar.scaleY(0.0);
        int y1 = (int)this.myScalar.scaleY(1.0);
        g.setColor(col);
        g.drawLine(x, y0, x, y1);
    }
}

