/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.range;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.features.AnimationTimeRange;
import org.rwshop.swing.animation.menus.MenuProvider;
import org.rwshop.swing.animation.timeline.TimelineComponent;
import org.rwshop.swing.animation.timeline.range.TimeRangeLayer;
import org.rwshop.swing.animation.timeline.range.TimeRangeMenuProvider;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimeRangeComponent
implements TimelineComponent,
PropertyChangeListener {
    private AnimationTimeRange myTimeRange = new AnimationTimeRange();
    private TimeRangeLayer myLayer = new TimeRangeLayer();
    private TimeRangeMenuProvider myMenuProvider = new TimeRangeMenuProvider();
    private JPanel myPanel;
    private CoordinateScalar myScalar;

    public TimeRangeComponent() {
        this.myLayer.setAnimationTimeRange(this.myTimeRange);
        this.myMenuProvider.setAnimationTimeRange(this.myTimeRange);
        this.myTimeRange.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void setPanel(JPanel panel) {
        this.myPanel = panel;
    }

    @Override
    public void setEditor(AnimationEditor editor) {
        this.myTimeRange.setEditor(editor);
    }

    @Override
    public void setScalar(CoordinateScalar scalar) {
        this.myScalar = scalar;
        this.myMenuProvider.setScalar(scalar);
        this.myLayer.setScalar(scalar);
    }

    @Override
    public MenuProvider getMenuProvider() {
        return this.myMenuProvider;
    }

    @Override
    public DrawableLayer getDrawLayer() {
        return this.myLayer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.myPanel == null) {
            return;
        }
        String name = evt.getPropertyName();
        if (name.equals("startTime") || name.equals("stopTime")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimeRangeComponent.this.myPanel.repaint();
                }
            });
        }
    }
}

