/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.position;

import javax.swing.JPanel;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.common.localization.Localizer;
import org.rwshop.swing.animation.menus.MenuProvider;
import org.rwshop.swing.animation.menus.UIMenuItem;
import org.rwshop.swing.animation.timeline.TimelineComponent;
import org.rwshop.swing.animation.timeline.position.PositionComponentLayer;
import org.rwshop.swing.animation.timeline.position.PositionSource;
import org.rwshop.swing.animation.timeline.position.PositionSourceMenuProvider;
import org.rwshop.swing.animation.timeline.position.PositionSourceToggle;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class PositionSourceComponent
implements TimelineComponent {
    private PositionSource myPositionSource;
    private PositionComponentLayer myLayer;
    private PositionSourceMenuProvider myMenuProvider;
    private JPanel myPanel;
    private CoordinateScalar myScalar;
    private PositionSourceToggle myAddToggle;
    private PositionSourceToggle myEditToggle;

    public PositionSourceComponent(BundleContext context) {
        this.myPositionSource = new PositionSource(context);
        this.myLayer = new PositionComponentLayer();
        this.myMenuProvider = new PositionSourceMenuProvider();
        this.myLayer.setPositionSource(this.myPositionSource);
        this.myAddToggle = new PositionSourceToggle(this.myPositionSource, true);
        this.myEditToggle = new PositionSourceToggle(this.myPositionSource, false);
        this.myMenuProvider.addMenuItem(new UIMenuItem(Localizer.$((String)"add.frames"), this.myAddToggle));
        this.myMenuProvider.addMenuItem(new UIMenuItem(Localizer.$((String)"move.joints"), this.myEditToggle));
    }

    @Override
    public void setPanel(JPanel panel) {
        this.myPanel = panel;
        this.myAddToggle.setPanel(panel);
        this.myEditToggle.setPanel(panel);
    }

    public PositionSource getPositionSource() {
        return this.myPositionSource;
    }

    @Override
    public void setEditor(AnimationEditor editor) {
        this.myPositionSource.setAnimationEditor(editor);
    }

    @Override
    public void setScalar(CoordinateScalar scalar) {
        this.myScalar = scalar;
        this.myLayer.setScalar(scalar);
    }

    @Override
    public MenuProvider getMenuProvider() {
        return this.myMenuProvider;
    }

    @Override
    public DrawableLayer getDrawLayer() {
        return this.myLayer;
    }
}

