/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.position;

import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.utils.AnimationEditListener;
import org.robokind.api.animation.utils.PositionAdder;
import org.robokind.api.common.osgi.ClassTracker;

public class PositionSource {
    private ClassTracker<PositionAdder> myPositionAdderTracker;
    private ClassTracker<AnimationEditListener> myEditListenerTracker;
    private AnimationEditor myEditor;
    private boolean myAddFlag;
    private boolean myEditFlag;

    public PositionSource(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myPositionAdderTracker = new ClassTracker(context, PositionAdder.class.getName(), null, null);
        this.myEditListenerTracker = new ClassTracker(context, AnimationEditListener.class.getName(), null, null);
        this.myAddFlag = false;
        this.myEditFlag = false;
    }

    public boolean getAddEnabled() {
        return this.myAddFlag;
    }

    public void setAddEnabled(boolean enabled) {
        this.myAddFlag = enabled;
    }

    public void toggleAddEnabled() {
        this.setAddEnabled(!this.myAddFlag);
    }

    public boolean getEditEnabled() {
        return this.myEditFlag;
    }

    public void setEditEnabled(boolean enabled) {
        List listeners = this.myEditListenerTracker.getServices();
        if (listeners == null) {
            return;
        }
        for (AnimationEditListener listener : listeners) {
            listener.setEditEnabled(enabled);
        }
        this.myEditFlag = enabled;
    }

    public void toggleEditEnabled() {
        this.setEditEnabled(!this.myEditFlag);
    }

    public void setAnimationEditor(AnimationEditor editor) {
        this.myEditor = editor;
    }

    public void addPositions(long time) {
        if (this.myEditor == null || !this.myAddFlag) {
            return;
        }
        PositionAdder pa = (PositionAdder)this.myPositionAdderTracker.getTopService();
        if (pa == null) {
            return;
        }
        pa.addPositions(this.myEditor, (double)time);
    }

    public void handlePositionEdit(long time, Map<Integer, Double> positions) {
        if (this.myEditor == null || !this.myEditFlag) {
            return;
        }
        List listeners = this.myEditListenerTracker.getServices();
        if (listeners == null) {
            return;
        }
        for (AnimationEditListener listener : listeners) {
            listener.handlePositions(time, positions);
        }
    }
}

