/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.position;

import java.awt.Color;
import java.awt.Graphics;
import org.rwshop.swing.animation.timeline.position.PositionSource;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class PositionComponentLayer
implements DrawableLayer {
    private PositionSource myPositionSource;
    private CoordinateScalar myScalar;
    private Color myEnabledColor = Color.GREEN;
    private Color myDisabledColor = Color.RED;

    public void setPositionSource(PositionSource posSource) {
        this.myPositionSource = posSource;
    }

    public void setScalar(CoordinateScalar s) {
        this.myScalar = s;
    }

    public void setEnabledColor(Color col) {
        if (col == null) {
            return;
        }
        this.myEnabledColor = col;
    }

    public void setDisabledColor(Color col) {
        if (col == null) {
            return;
        }
        this.myDisabledColor = col;
    }

    public void paint(Graphics g) {
        if (this.myPositionSource == null || this.myScalar == null) {
            return;
        }
        boolean add = this.myPositionSource.getAddEnabled();
        this.drawTitle(g, "Add Frames", add, 0);
        boolean edit = this.myPositionSource.getEditEnabled();
        this.drawTitle(g, "Move Joints", edit, 1);
    }

    private void drawTitle(Graphics g, String title, boolean enabled, int order) {
        Color col = enabled ? this.myEnabledColor : this.myDisabledColor;
        int y = (order + 1) * 18;
        g.setColor(col);
        g.drawString(title, 20, y);
    }
}

