/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.listener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.features.SynchronizedPointGroup;
import org.rwshop.swing.animation.EditorElement;
import org.rwshop.swing.animation.timeline.TimelineAnimation;
import org.rwshop.swing.animation.timeline.TimelineChannel;
import org.rwshop.swing.animation.timeline.TimelineMotionPath;
import org.rwshop.swing.animation.timeline.listener.TimelineContextMenuManager;
import org.rwshop.swing.animation.timeline.position.PositionSource;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.utils.SettingsRepository;

public class TimelineMouseListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final Logger theLogger = Logger.getLogger(TimelineMouseListener.class.getName());
    private AnimationEditor myController;
    private TimelineAnimation myTimeline;
    private CoordinateScalar myScalar;
    private TimelineContextMenuManager myContextMenu;
    private int myLastButton;
    private JPanel myPanel;
    private boolean myPathChanging;
    private Double myLastClickX;
    private Double myLastClickY;
    private PositionSource myPositionSource;

    public TimelineMouseListener(CoordinateScalar s, TimelineContextMenuManager contextMenu) {
        this.myScalar = s;
        this.myContextMenu = contextMenu;
        this.myLastButton = 0;
        this.myPathChanging = false;
    }

    public void setAnimation(AnimationEditor controller, TimelineAnimation timeline) {
        this.myController = controller;
        this.myTimeline = timeline;
        this.myLastButton = 0;
        this.myPathChanging = false;
    }

    public void setPositionSource(PositionSource ps) {
        this.myPositionSource = ps;
    }

    public void setPanel(JPanel panel) {
        this.myPanel = panel;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.myLastButton = e.getButton();
        this.setLastClick(e);
        if (this.myContextMenu.tryShowPopup(e)) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        MotionPathEditor motionPath = this.getSelectedPath();
        if (motionPath == null) {
            this.selectChannelOrPath(e);
            return;
        }
        int i = TimelineMotionPath.findControlPoint(motionPath, e.getX(), e.getY(), this.myScalar, SettingsRepository.theHoverDistance);
        if (i >= 0) {
            motionPath.select((Object)this, i, motionPath.getSharedHistory());
            this.myPathChanging = true;
            return;
        }
        if (motionPath.getSelected() != null) {
            motionPath.deselect((Object)this);
        }
        boolean selected = this.selectChannel(e);
        boolean bl = selected = this.selectMotionPath(e) || selected;
        if (!this.selectChannelOrPath(e) && e.getClickCount() == 2) {
            double x = this.myScalar.unscaleX((double)e.getX());
            this.addFeedback(x);
        }
    }

    private void addFeedback(double x) {
        if (this.myPositionSource == null) {
            return;
        }
        this.myPositionSource.addPositions((long)x);
    }

    private boolean selectChannelOrPath(MouseEvent e) {
        boolean selected = this.selectChannel(e);
        return this.selectMotionPath(e) || selected;
    }

    private boolean addPointToLine(MotionPathEditor motionPath, MouseEvent e) {
        if (this.myTimeline == null) {
            return false;
        }
        TimelineChannel selected = this.myTimeline.getSelected();
        if (selected == null) {
            return false;
        }
        TimelineMotionPath tmp = selected.getSelected();
        return tmp != null && tmp.contains(e.getX(), e.getY(), SettingsRepository.theHoverDistance);
    }

    private boolean selectChannel(MouseEvent e) {
        if (this.myTimeline == null || this.myController == null) {
            return false;
        }
        for (int j = 0; j < this.myTimeline.getChannels().size(); ++j) {
            TimelineChannel cc = this.myTimeline.getChannels().get(j);
            if (!cc.getController().hasFlag(EditState.VISIBLE) || !cc.contains(e.getX(), e.getY(), SettingsRepository.theHoverDistance)) continue;
            this.myController.select((Object)this, j, this.myController.getSharedHistory());
            return true;
        }
        return false;
    }

    private boolean selectMotionPath(MouseEvent e) {
        if (this.myTimeline == null || this.myController == null) {
            return false;
        }
        TimelineChannel selected = this.myTimeline.getSelected();
        if (selected == null) {
            return false;
        }
        for (int j = 0; j < selected.getMotionPaths().size(); ++j) {
            ChannelEditor editor;
            TimelineMotionPath sel = selected.getMotionPaths().get(j);
            if (!sel.contains(e.getX(), e.getY(), SettingsRepository.theHoverDistance) || (editor = selected.getController()) == null) continue;
            editor.select((Object)this, j, editor.getSharedHistory());
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.myLastButton = 0;
        this.myContextMenu.tryShowPopup(e);
        MotionPathEditor motionPath = this.getSelectedPath();
        this.endPathChange();
        if (motionPath == null) {
            return;
        }
        motionPath.deselect((Object)this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setLastClick(e);
        this.myContextMenu.tryShowPopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.myLastButton != 1) {
            return;
        }
        if (this.myController == null) {
            return;
        }
        ChannelEditor channel = (ChannelEditor)this.myController.getSelected();
        if (channel == null) {
            return;
        }
        MotionPathEditor motionPath = (MotionPathEditor)channel.getSelected();
        if (motionPath == null) {
            return;
        }
        double y = this.myScalar.unscaleY((double)e.getY());
        long x = (long)this.myScalar.unscaleX((double)e.getX());
        double xDiff = (double)x - this.myLastClickX;
        double yDiff = y - this.myLastClickY;
        double xDiff2 = (double)e.getX() - this.myScalar.scaleX(this.myLastClickX.doubleValue());
        double yDiff2 = (double)e.getY() - this.myScalar.scaleY(this.myLastClickY.doubleValue());
        if (e.isShiftDown()) {
            if (Math.abs(xDiff2) >= Math.abs(yDiff2)) {
                y = this.myLastClickY;
            } else {
                x = this.myLastClickX.longValue();
            }
        }
        if (this.myPathChanging && e.isControlDown()) {
            motionPath.movePath((Object)this, (long)xDiff, yDiff, motionPath.getSharedHistory());
            return;
        }
        int sel = motionPath.dragSelectedPoint((Object)this, x, y, motionPath.getSharedHistory());
        if (sel != -1) {
            this.move(channel, motionPath, sel, x, y);
            return;
        }
        this.drag(e);
    }

    private void drag(MouseEvent e) {
    }

    private boolean move(ChannelEditor channel, MotionPathEditor motionPath, int sel, long x, double y) {
        boolean move;
        if (this.myPositionSource == null) {
            return false;
        }
        boolean bl = move = !channel.hasFlag(EditState.DISABLED) && !motionPath.hasFlag(EditState.DISABLED);
        if (!move) {
            return false;
        }
        if (sel == -1) {
            return false;
        }
        ControlPointEditor point = (ControlPointEditor)motionPath.getChild(sel);
        Map<Integer, Double> positions = this.getChannelPositions(point, x, y);
        if (positions == null || positions.isEmpty()) {
            return false;
        }
        this.myPositionSource.handlePositionEdit(x, positions);
        return true;
    }

    private Map<Integer, Double> getChannelPositions(ControlPointEditor point, long time, Double pos) {
        TimelineChannel sel;
        if (this.myTimeline == null || this.myController == null) {
            return null;
        }
        HashMap<Integer, Double> positions = new HashMap<Integer, Double>();
        for (int j = 0; j < this.myTimeline.getChannels().size(); ++j) {
            Double y;
            TimelineChannel timelineChannel = this.myTimeline.getChannels().get(j);
            ChannelEditor chan = timelineChannel.getController();
            if (chan.hasFlag(EditState.DISABLED) || (y = timelineChannel.getY(time)) == null) continue;
            positions.put(timelineChannel.getController().getId(), y);
        }
        if (point.isGrouped()) {
            SynchronizedPointGroup group = point.getPointGroup();
            group.addPositions(positions);
        } else if (pos != null && (sel = this.myTimeline.getSelected()) != null) {
            positions.put(sel.getController().getId(), pos);
        }
        return positions;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.myTimeline == null) {
            return;
        }
        this.hover(e, SettingsRepository.theHoverDistance, this.myTimeline.getChannels());
        TimelineChannel selectedChannel = this.myTimeline.getSelected();
        if (selectedChannel == null) {
            return;
        }
        this.hover(e, SettingsRepository.theHoverDistance, selectedChannel.getMotionPaths());
        TimelineMotionPath selectedTMP = selectedChannel.getSelected();
        if (selectedTMP == null) {
            return;
        }
        this.hover(e, SettingsRepository.theHoverDistance, selectedTMP.getControlPoints());
    }

    private void hover(MouseEvent e, double dist, List<? extends EditorElement> elems) {
        for (EditorElement editorElement : elems) {
            boolean h = editorElement.contains(e.getX(), e.getY(), dist);
            Object editor = editorElement.getController();
            if (editor == null) continue;
            editor.setState((Object)this, EditState.HOVER, h, editor.getSharedHistory());
        }
    }

    private MotionPathEditor getSelectedPath() {
        if (this.myController == null) {
            return null;
        }
        ChannelEditor channel = (ChannelEditor)this.myController.getSelected();
        if (channel == null) {
            return null;
        }
        return (MotionPathEditor)channel.getSelected();
    }

    private TimelineMotionPath getSelectedTimelinePath() {
        if (this.myTimeline == null) {
            return null;
        }
        TimelineChannel channel = this.myTimeline.getSelected();
        if (channel == null) {
            return null;
        }
        return channel.getSelected();
    }

    private void setLastClick(MouseEvent e) {
        TimelineMotionPath mp;
        this.myLastClickX = this.myScalar.unscaleX((double)e.getX());
        this.myLastClickY = this.myScalar.unscaleY((double)e.getY());
        if (e.isControlDown() && (mp = this.getSelectedTimelinePath()) != null && mp.contains(e.getX(), e.getY(), SettingsRepository.theHoverDistance)) {
            this.myPathChanging = true;
        }
    }

    private void endPathChange() {
        if (!this.myPathChanging) {
            return;
        }
        this.myPathChanging = false;
        MotionPathEditor mp = this.getSelectedPath();
        if (mp != null) {
            mp.endPathChange(false, mp.getSharedHistory());
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!e.isShiftDown()) {
            return;
        }
        double scroll = e.getWheelRotation();
        scroll = Math.pow(0.95, scroll);
        MotionPathEditor mp = this.getSelectedPath();
        if (mp != null) {
            this.myPathChanging = true;
            mp.scalePath((Object)this, scroll, (long)this.myScalar.unscaleX((double)e.getX()), mp.getSharedHistory());
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.myPositionSource == null) {
            return;
        }
        if (e.getKeyCode() == 70) {
            boolean val = !this.myPositionSource.getAddEnabled();
            this.myPositionSource.setAddEnabled(val);
            this.repaint();
        } else if (e.getKeyCode() == 77) {
            boolean val = !this.myPositionSource.getEditEnabled();
            this.myPositionSource.setEditEnabled(val);
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 16: {
                this.endPathChange();
                break;
            }
            case 70: {
                break;
            }
        }
    }

    private void repaint() {
        if (this.myPanel != null) {
            RepaintManager.currentManager(this.myPanel).markCompletelyDirty(this.myPanel);
        }
    }
}

