/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.listener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.utils.RKSource;
import org.rwshop.swing.animation.actions.FileAction;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimelineKeyListener
implements KeyListener {
    private JPanel myPanel;
    private AnimationEditor myController;
    private int myKeyMode;
    private CoordinateScalar myScalar;
    private HistoryStack mySharedHistory;

    public TimelineKeyListener(JPanel p, CoordinateScalar s) {
        this.myScalar = s;
        this.myPanel = p;
        this.myKeyMode = 0;
    }

    public void setController(AnimationEditor controller) {
        this.myController = controller;
        this.mySharedHistory = this.myController == null ? null : this.myController.getSharedHistory();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.myController == null || this.mySharedHistory == null) {
            return;
        }
        if (e.isControlDown() && (e.isShiftDown() && e.getKeyCode() == 90 || e.getKeyCode() == 89)) {
            this.mySharedHistory.forward(1);
            e.consume();
            return;
        }
        if (e.isControlDown() && e.getKeyCode() == 90) {
            this.mySharedHistory.back(1);
            e.consume();
            return;
        }
        if (!e.isControlDown() || e.getKeyCode() != 83) {
            this.kp0(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineKeyListener.this.myPanel.repaint();
            }
        });
    }

    private void kp0(KeyEvent e) {
        if (this.myController == null || this.mySharedHistory == null) {
            return;
        }
        if (!e.isControlDown()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 83: {
                try {
                    new FileAction.Save((RKSource<AnimationEditor>)new RKSource.SourceImpl((Object)this.myController), true).actionPerformed(null);
                    break;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

