/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.listener;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.actions.AnimationPlayerAction;
import org.robokind.api.animation.editor.actions.ChannelActions;
import org.robokind.api.animation.editor.actions.ControlPointActions;
import org.robokind.api.animation.editor.actions.HistoryAction;
import org.robokind.api.animation.editor.actions.MotionPathActions;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.common.utils.RKSource;
import org.rwshop.swing.animation.actions.FileAction;
import org.rwshop.swing.animation.actions.UIAction;
import org.rwshop.swing.animation.menus.MenuProvider;
import org.rwshop.swing.animation.menus.UIMenuItem;
import org.rwshop.swing.animation.timeline.AnimationTimelinePanel;
import org.rwshop.swing.animation.timeline.TimelineAnimation;
import org.rwshop.swing.animation.timeline.TimelineChannel;
import org.rwshop.swing.animation.timeline.TimelineMotionPath;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.utils.SettingsRepository;

public class TimelineContextMenuManager {
    private TimelineAnimation myTimeline;
    private CoordinateScalar myScalar;
    private AnimationTimelinePanel myPanel;
    private List<JComponent> myDefaultItems;
    private RKSource<AnimationEditor> myControllerSource;
    private RKSource<HistoryStack> myHistorySource;
    private List<MenuProvider> myProviders;

    public TimelineContextMenuManager(AnimationTimelinePanel panel, CoordinateScalar scalar) {
        this.myPanel = panel;
        this.myScalar = scalar;
        this.myHistorySource = new RKSource.SourceImpl();
        this.myControllerSource = new RKSource.SourceImpl();
        this.myDefaultItems = new ArrayList<JComponent>();
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"play"), (ActionListener)new AnimationPlayerAction.Play(this.myControllerSource)));
        this.myDefaultItems.add(new JPopupMenu.Separator());
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"zoom.in"), new UIAction.Zoom(scalar, panel, 1.2)));
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"zoom.out"), new UIAction.Zoom(scalar, panel, 0.8)));
        this.myDefaultItems.add(new JPopupMenu.Separator());
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"undo"), (ActionListener)HistoryAction.Undo(this.myHistorySource)));
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"redo"), (ActionListener)HistoryAction.Redo(this.myHistorySource)));
        this.myDefaultItems.add(new JPopupMenu.Separator());
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"save"), new FileAction.Save(this.myControllerSource, false)));
        this.myDefaultItems.add(new UIMenuItem(Localizer.$((String)"save.as"), new FileAction.Save(this.myControllerSource, true)));
        this.myProviders = new ArrayList<MenuProvider>();
    }

    public void addMenuProvider(MenuProvider provider) {
        if (!this.myProviders.contains(provider)) {
            this.myProviders.add(provider);
        }
    }

    public void removeMenuProvider(MenuProvider provider) {
        if (this.myProviders.contains(provider)) {
            this.myProviders.remove(provider);
        }
    }

    public void setTimeline(TimelineAnimation timeline) {
        this.myTimeline = timeline;
        if (this.myTimeline == null) {
            return;
        }
        AnimationEditor controller = this.myTimeline.getController();
        this.myControllerSource.set((Object)controller);
        if (controller == null) {
            return;
        }
        this.myHistorySource.set((Object)controller.getSharedHistory());
    }

    public boolean tryShowPopup(MouseEvent e) {
        if (this.myTimeline == null) {
            return false;
        }
        if (!this.shouldShowPopup(e)) {
            return false;
        }
        List<JComponent> menuItems = this.getMenuItems(e);
        menuItems.add(UIAction.AddChannelMenu(this.myTimeline.getController()));
        this.addMenuItems(menuItems, this.getProvidedMenus(e));
        this.addMenuItems(menuItems, this.myDefaultItems);
        this.showMenu(menuItems, e.getX(), e.getY());
        return true;
    }

    private List<JComponent> getProvidedMenus(MouseEvent e) {
        ArrayList<JComponent> menus = new ArrayList<JComponent>(this.myProviders.size());
        for (MenuProvider provider : this.myProviders) {
            JMenu menu = provider.getContextSubMenu(e);
            if (menu == null) continue;
            menus.add(menu);
        }
        return menus;
    }

    private void showMenu(List<JComponent> items, int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        for (JComponent item : items) {
            menu.add(item);
        }
        menu.show((Component)((Object)this.myPanel), x, y);
    }

    private boolean shouldShowPopup(MouseEvent e) {
        return e.getButton() == 3 && e.isPopupTrigger();
    }

    private List<JComponent> getMenuItems(MouseEvent e) {
        TimelineChannel channel = null;
        TimelineMotionPath path = null;
        channel = this.myTimeline.getSelected();
        if (channel != null) {
            path = channel.getSelected();
        }
        List<JComponent> menu = this.getSelectedMenuItems(channel, path, e);
        List<JComponent> hoverMenu = this.getHoverChannelMenuItems(e);
        this.addMenuItems(menu, hoverMenu);
        return menu;
    }

    private List<JComponent> getSelectedMenuItems(TimelineChannel channel, TimelineMotionPath path, MouseEvent e) {
        ArrayList<JComponent> items = new ArrayList<JComponent>();
        if (path != null) {
            Point2D.Double p = new Point2D.Double(this.myScalar.unscaleX((double)e.getX()), this.myScalar.unscaleY((double)e.getY()));
            MotionPathEditor controller = path.getController();
            items.add(new UIMenuItem(Localizer.$((String)"add.control.point"), (ActionListener)MotionPathActions.Add((MotionPathEditor)controller, (Point2D)p)));
            items.addAll(this.getHoverControlPointMenuItems(path, e));
        }
        if (channel != null) {
            ChannelEditor controller = channel.getController();
            items.add(new UIMenuItem(Localizer.$((String)"add.motion.path"), (ActionListener)ChannelActions.Add((ChannelEditor)controller)));
        }
        return items;
    }

    private void addMenuItems(List<JComponent> dest, List<JComponent> src) {
        if (dest.size() > 0 && src.size() > 0) {
            dest.add(new JPopupMenu.Separator());
        }
        dest.addAll(src);
    }

    private JMenu buildMenu(String label, List<JComponent> items) {
        JMenu menu = new JMenu(label);
        for (JComponent item : items) {
            menu.add(item);
        }
        return menu;
    }

    private List<JComponent> getHoverChannelMenuItems(MouseEvent e) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        for (int j = 0; j < this.myTimeline.getChannels().size(); ++j) {
            TimelineChannel channel = this.myTimeline.getChannels().get(j);
            ChannelEditor controller = channel.getController();
            boolean visible = EditState.hasFlag((int)controller.getRestrictiveFlags(), (EditState)EditState.VISIBLE);
            boolean selected = EditState.hasFlag((int)controller.getInheritedFlags(), (EditState)EditState.SELECTED);
            if (!visible && !selected || !channel.contains(e.getX(), e.getY(), SettingsRepository.theHoverDistance)) continue;
            menuItems.add(this.buildMenu(controller.getName(), this.getChannelMenuItems(controller)));
            menuItems.addAll(this.getHoverMotionPathMenuItems(channel, e));
        }
        return menuItems;
    }

    private List<JComponent> getChannelMenuItems(ChannelEditor controller) {
        List<JComponent> items = UIMenuItem.buildMenuItems(new String[]{Localizer.$((String)"add.motion.path")}, new ActionListener[]{ChannelActions.Add((ChannelEditor)controller)});
        items.addAll(UIMenuItem.buildStateMenuItems((AbstractEditor)controller));
        return items;
    }

    private List<JComponent> getHoverMotionPathMenuItems(TimelineChannel channel, MouseEvent e) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        for (int j = 0; j < channel.getMotionPaths().size(); ++j) {
            TimelineMotionPath path = channel.getMotionPaths().get(j);
            MotionPathEditor controller = path.getController();
            boolean visible = EditState.hasFlag((int)controller.getRestrictiveFlags(), (EditState)EditState.VISIBLE);
            boolean selected = EditState.hasFlag((int)controller.getInheritedFlags(), (EditState)EditState.SELECTED);
            if (!visible && !selected || !path.contains(e.getX(), e.getY(), SettingsRepository.theHoverDistance)) continue;
            menuItems.add(this.buildMenu(controller.getName(), this.getMotionPathMenuItems(controller, e)));
        }
        return menuItems;
    }

    private List<JComponent> getMotionPathMenuItems(MotionPathEditor controller, MouseEvent e) {
        Point2D.Double p = new Point2D.Double(this.myScalar.unscaleX((double)e.getX()), this.myScalar.unscaleY((double)e.getY()));
        List<JComponent> items = UIMenuItem.buildMenuItems(new String[]{Localizer.$((String)"add.control.point"), Localizer.$((String)"remove")}, new ActionListener[]{MotionPathActions.Add((MotionPathEditor)controller, (Point2D)p), MotionPathActions.Remove((MotionPathEditor)controller)});
        items.addAll(UIMenuItem.buildStateMenuItems((AbstractEditor)controller));
        return items;
    }

    private List<JComponent> getHoverControlPointMenuItems(TimelineMotionPath path, MouseEvent e) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MotionPathEditor editor = path.getController();
        int i = TimelineMotionPath.findControlPoint(editor, e.getX(), e.getY(), this.myScalar, SettingsRepository.theHoverDistance);
        if (i >= 0) {
            ControlPointEditor cpc = (ControlPointEditor)editor.getChild(i);
            menuItems.addAll(this.getControlPointItems(cpc));
        }
        return menuItems;
    }

    private List<JComponent> getControlPointItems(ControlPointEditor controller) {
        if (!controller.isGrouped()) {
            return UIMenuItem.buildMenuItems(new String[]{Localizer.$((String)"remove")}, new ActionListener[]{ControlPointActions.Remove((ControlPointEditor)controller)});
        }
        return UIMenuItem.buildMenuItems(new String[]{Localizer.$((String)"remove"), "Unlink"}, new ActionListener[]{ControlPointActions.Remove((ControlPointEditor)controller), controller.getUnlinkAction()});
    }
}

