/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.listener;

import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;

public class AnimationRepaintListener
extends EditorListener {
    private JComponent myPanel;
    private boolean myPaint;

    public AnimationRepaintListener(JComponent panel) {
        this.myPanel = panel;
        this.myPaint = true;
    }

    public void setPaint(boolean val) {
        this.myPaint = val;
    }

    public void repaint() {
        if (!this.myPaint) {
            return;
        }
        RepaintManager.currentManager(this.myPanel).markCompletelyDirty(this.myPanel);
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
        this.repaint();
    }

    public void itemAdded(Object invoker, Object controller, int index) {
        this.repaint();
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
        this.repaint();
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
        this.repaint();
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
        this.repaint();
    }

    public void structureChanged(Object invoker, Object controller) {
        this.repaint();
    }
}

