/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.layers;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.player.AnimationJobListener;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class AnimationProgressLayer
implements AnimationJobListener,
DrawableLayer {
    public static final Color PLAYING_COLOR = new Color(0.2f, 0.4f, 0.9f, 0.4f);
    public static final Color PAUSED_COLOR = new Color(0.8f, 0.65f, 0.2f, 0.4f);
    public static final Color STOPPED_COLOR = new Color(0.9f, 0.2f, 0.1f, 0.4f);
    public static final Color COMPLETED_COLOR = new Color(0.2f, 0.9f, 0.35f, 0.4f);
    private JPanel myPanel;
    private long myStartTime = 0L;
    private Long myEndTime = null;
    private long myCurrentTime = 0L;
    private Color myColor = PLAYING_COLOR;
    private CoordinateScalar myScalar;

    public AnimationProgressLayer(CoordinateScalar scalar) {
        this.myScalar = scalar;
    }

    public void setPanel(JPanel panel) {
        this.myPanel = panel;
    }

    public void animationAdvanced(long time) {
        this.myCurrentTime = time;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnimationProgressLayer.this.myPanel.repaint();
            }
        });
    }

    public void animationStart(long start, Long end) {
        this.myStartTime = start;
        this.myEndTime = end;
    }

    public void setColor(Color col) {
        this.myColor = col;
    }

    public void paint(Graphics g) {
        int x1 = (int)this.myScalar.scaleX((double)this.myStartTime);
        int y1 = (int)this.myScalar.scaleY(1.0);
        int w = (int)this.myScalar.scaleX((double)(this.myCurrentTime - this.myStartTime));
        if (w < 0) {
            return;
        }
        int h = (int)this.myScalar.scaleY(0.0);
        g.setColor(this.myColor);
        g.fillRect(x1, y1, w, h);
        g.setColor(STOPPED_COLOR);
        if (this.myEndTime != null) {
            int end = (int)this.myScalar.scaleX((double)this.myEndTime.intValue());
            g.drawLine(end, y1, end, h);
        }
    }
}

