/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline.layers;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class AnimationPlayerLayer
implements DrawableLayer {
    private long myTime = -1L;
    private CoordinateScalar myScalar;
    private JPanel myPanel;
    private Map<Integer, Double> myLastPositions;
    private Long myLastTime = null;
    private static Color[] cols = new Color[]{new Color(255, 196, 196, 96), new Color(255, 240, 240, 128), Color.darkGray, new Color(96, 0, 0)};

    public AnimationPlayerLayer(JPanel panel, CoordinateScalar s) {
        this.myScalar = s;
        this.myPanel = panel;
    }

    public void tick(long time, Map<Integer, Double> positions) {
        final int old = (int)this.myScalar.scaleX((double)this.myTime);
        this.myLastPositions = positions;
        if (this.myLastTime == null || time - this.myLastTime >= 40L) {
            this.myLastTime = this.myTime;
            this.myTime = time;
            final int s = (int)this.myScalar.scaleX((double)time);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnimationPlayerLayer.this.myPanel.paintImmediately(old - 2, 0, s - old + 10, AnimationPlayerLayer.this.myPanel.getHeight());
                }
            });
        }
    }

    public void start() {
    }

    public void end() {
        this.myTime = -1L;
        this.myLastTime = null;
        this.myPanel.repaint();
    }

    public void paint(Graphics g) {
        if (this.myTime < 0L) {
            return;
        }
        g.setColor(Color.MAGENTA);
        int tX = (int)this.myScalar.scaleX((double)this.myTime);
        int y = this.myPanel.getHeight();
        g.drawLine(tX, y, tX, 0);
    }

    private void paintPositions(Graphics g, int x) {
        for (Map.Entry<Integer, Double> e : this.myLastPositions.entrySet()) {
            double d = e.getValue();
            if (d < 0.0) continue;
            int y = (int)this.myScalar.scaleY(e.getValue().doubleValue());
            int out1 = 6;
            int out2 = 12;
            g.drawOval(x - out1, y - out1, out2, out2);
        }
    }
}

