/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.animation.utils.ChannelsParameter;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.rwshop.swing.animation.ElementSettings;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.config.PointProperties;
import org.rwshop.swing.animation.config.PropertyReader;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.timeline.TimelineAnimation;
import org.rwshop.swing.animation.timeline.layers.AnimationPlayerLayer;
import org.rwshop.swing.animation.timeline.listener.AnimationRepaintListener;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.DefaultCoordinateScalar;
import org.rwshop.swing.common.utils.SettingsRepository;

public class TimelineOverviewPanel
extends JPanel
implements ComponentListener {
    private CoordinateScalar myScalar;
    private AnimationEditor myController;
    private TimelineAnimation myAnimationTimeline;
    private AnimationRepaintListener myRepainter;
    private List<DrawableLayer> myLayers;
    private AnimationPlayerLayer myPlayerListener;
    private ElementSettings myElementSettings;
    private boolean myInitializedFlag;

    public TimelineOverviewPanel() {
        this.initComponents();
        this.myInitializedFlag = false;
        this.ensureInitialized();
    }

    private boolean ensureInitialized() {
        if (this.myInitializedFlag) {
            return true;
        }
        if (!SettingsRepository.isInitialized()) {
            return false;
        }
        this.myInitializedFlag = true;
        try {
            this.myScalar = new DefaultCoordinateScalar();
            this.myScalar.setXOffset(5.0);
            this.myScalar.setYOffset(5.0);
            PropertySet<PathProperties> pathProps = PropertyReader.getPathProperties(null, "simple.channel");
            PropertySet<PointProperties> pointProps = PropertyReader.getPointProperties("simplepoint");
            PathProperties.PathConfigRenderer pathRenderer = new PathProperties.PathConfigRenderer(pathProps);
            PointProperties.PointConfigRenderer pointRenderer = new PointProperties.PointConfigRenderer(pointProps);
            this.myElementSettings = new ElementSettings(this.myScalar, pathRenderer, pointRenderer);
            this.myElementSettings.setScaler(this.myScalar);
            this.myRepainter = new AnimationRepaintListener(this);
            this.myLayers = new ArrayList<DrawableLayer>();
            this.addComponentListener(this);
        }
        catch (Throwable t) {
            this.myInitializedFlag = false;
        }
        return this.myInitializedFlag;
    }

    public void addLayer(DrawableLayer layer) {
        if (!this.ensureInitialized()) {
            return;
        }
        this.myLayers.add(layer);
    }

    public void setController(AnimationEditor controller) {
        if (!this.ensureInitialized()) {
            return;
        }
        if (this.myAnimationTimeline != null) {
            this.myAnimationTimeline.cleanConsumer();
        }
        this.myRepainter.cleanConsumer();
        this.myController = controller;
        this.myAnimationTimeline = new TimelineAnimation(this.myController, this.myElementSettings);
        if (this.myController == null) {
            return;
        }
        this.myController.addConsumer((EditorListener)this.myAnimationTimeline);
        this.myController.recursiveAdd((EditorListener)this.myRepainter);
        this.setSize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineOverviewPanel.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setSize();
        super.paintComponent(g);
        if (!this.ensureInitialized() || this.myAnimationTimeline == null || this.myController == null) {
            return;
        }
        if (SettingsRepository.getAntiAliasing()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.myAnimationTimeline.paint(g);
        for (DrawableLayer layer : this.myLayers) {
            layer.paint(g);
        }
        ChannelEditor channel = (ChannelEditor)this.myController.getSelected();
        if (channel == null) {
            return;
        }
        ChannelsParameterSource paramSource = AnimationUtils.getChannelsParameterSource();
        if (paramSource == null) {
            return;
        }
        int id = channel.getId();
        Double def = null;
        for (ChannelsParameter chanParam : paramSource.getChannelParameters()) {
            if (chanParam.getChannelID() != id) continue;
            def = chanParam.getDefaultPosition().getValue();
            break;
        }
        if (def == null) {
            return;
        }
        int y = (int)this.myScalar.scaleY(def.doubleValue());
        g.setColor(channel.getPrimaryColor());
        g.drawLine(0, y, this.getWidth(), y);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 54, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 32, Short.MAX_VALUE));
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setSize();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setSize();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void setSize() {
        if (!this.ensureInitialized() || this.myController == null) {
            return;
        }
        double w = this.getWidth() - 10;
        long time = this.myController.getEnd();
        double scale = w / (double)time;
        this.myScalar.setScaleX(scale);
        this.myScalar.setScaleY((double)(this.getHeight() - 10));
    }
}

