/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.compiled.CompiledPath;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.rwshop.swing.animation.EditorElement;
import org.rwshop.swing.animation.ElementSettings;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.timeline.TimelineControlPoint;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimelineMotionPath
extends EditorListener
implements EditorElement {
    private MotionPathEditor myController;
    private List<TimelineControlPoint> myControlPoints;
    private ElementSettings mySettings;
    private PathProperties myPathProperties;

    public TimelineMotionPath(MotionPathEditor mp, ElementSettings es, PathProperties pathProps) {
        this.mySettings = es;
        this.myController = mp;
        this.myPathProperties = pathProps;
        this.setControlPoints();
    }

    private void setControlPoints() {
        if (this.myControlPoints != null) {
            for (TimelineControlPoint tcp : this.myControlPoints) {
                tcp.getController().clearConsumers();
            }
        }
        this.myControlPoints = new ArrayList<TimelineControlPoint>();
        for (ControlPointEditor p : this.myController.getChildren()) {
            TimelineControlPoint tcp = new TimelineControlPoint(p, this.mySettings);
            p.addConsumer((EditorListener)tcp);
            this.myControlPoints.add(tcp);
        }
    }

    @Override
    public boolean contains(int x, int y, double distance) {
        long end;
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return false;
        }
        long stepLength = (long)scalar.unscaleX(distance);
        long start = (long)scalar.unscaleX((double)x - distance);
        CompiledPath cp = this.myController.getCompiledPath(start, end = (long)scalar.unscaleX((double)x + distance), stepLength);
        if (cp == null) {
            return false;
        }
        int i = x - (int)distance;
        while ((double)i <= (double)x + distance) {
            if (Point2D.Double.distance(x, y, i, this.getY(i, cp)) <= distance) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getY(int x, CompiledPath cp) {
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return -1;
        }
        double lT = scalar.unscaleX((double)x);
        double lP = cp.estimatePosition((long)lT);
        return (int)scalar.scaleY(lP);
    }

    private void drawControlPoints(Graphics g) {
        int i = 0;
        for (TimelineControlPoint cp : this.myControlPoints) {
            cp.paint(g);
            ++i;
        }
    }

    public void paint(Graphics g) {
        PathProperties.PathConfigRenderer renderer;
        CoordinateScalar scalar;
        if (this.myControlPoints.isEmpty()) {
            return;
        }
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return;
        }
        PathProperties.PathConfigRenderer pathConfigRenderer = renderer = this.mySettings == null ? null : this.mySettings.getPathRenderer();
        if (renderer == null) {
            return;
        }
        if (this.myController.hasFlag(EditState.VISIBLE)) {
            boolean drawControls;
            boolean bl = drawControls = this.myController.hasFlag(EditState.SELECTED) && !this.myController.isLocked();
            if (drawControls) {
                this.drawControlLines(g);
            }
            renderer.paint(g, (List<Point2D>)this.myController.getInterpolatedPoints(), this.myController.getInheritedFlags(), scalar, this.myPathProperties);
            if (drawControls) {
                this.drawControlPoints(g);
            }
        } else if (this.myController.hasFlag(EditState.SELECTED)) {
            renderer.paint(g, (List<Point2D>)this.myController.getInterpolatedPoints(), scalar, "outline", null);
        }
        if (this.myController.getTempPath() != null) {
            renderer.paint(g, (List<Point2D>)this.myController.getTempPath().getInterpolatedPoints(), scalar, "outline", null);
        }
    }

    public void drawControlLines(Graphics g) {
        PathProperties.PathConfigRenderer renderer;
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return;
        }
        PathProperties.PathConfigRenderer pathConfigRenderer = renderer = this.mySettings == null ? null : this.mySettings.getPathRenderer();
        if (renderer == null) {
            return;
        }
        renderer.paint(g, (List<Point2D>)this.myController.getControlPoints(), scalar, "controllines", null);
    }

    public List<TimelineControlPoint> getControlPoints() {
        return this.myControlPoints;
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
        this.setSelect(oldIndex, false);
        this.setSelect(newIndex, true);
    }

    private void setSelect(int i, boolean val) {
        if (i < 0 || i >= this.myControlPoints.size()) {
            return;
        }
        TimelineControlPoint child = this.myControlPoints.get(i);
        if (child != null && child.getController() != null) {
            ControlPointEditor ae = child.getController();
            ae.setState((Object)this, EditState.SELECTED, val, ae.getSharedHistory());
        }
    }

    public void itemAdded(Object invoker, Object controller, int index) {
        ControlPointEditor p = (ControlPointEditor)this.myController.getChild(index);
        TimelineControlPoint cp = new TimelineControlPoint(p, this.mySettings);
        p.addConsumer((EditorListener)cp);
        this.myControlPoints.add(index, cp);
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
        this.myControlPoints.remove(index);
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
        TimelineControlPoint p = this.myControlPoints.remove(oldIndex);
        p.setPoint((ControlPointEditor)this.myController.getChild(newIndex));
        this.myControlPoints.add(newIndex, p);
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
        if (state == EditState.SELECTED) {
            // empty if block
        }
    }

    public MotionPathEditor getController() {
        return this.myController;
    }

    public void structureChanged(Object invoker, Object controller) {
    }

    public static int findControlPoint(MotionPathEditor editor, int x, int y, CoordinateScalar s, double distance) {
        if (editor == null || s == null) {
            return -1;
        }
        List points = editor.getControlPoints();
        for (int i = 0; i < points.size(); ++i) {
            Point2D p = (Point2D)points.get(i);
            if (!(Point2D.Double.distance(s.scaleX(p), s.scaleY(p), x, y) <= distance)) continue;
            return i;
        }
        return -1;
    }
}

