/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.List;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.rwshop.swing.animation.EditorElement;
import org.rwshop.swing.animation.ElementSettings;
import org.rwshop.swing.animation.config.PointProperties;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimelineControlPoint
extends EditorListener
implements EditorElement {
    private ControlPointEditor myController;
    private ElementSettings mySettings;

    public TimelineControlPoint(ControlPointEditor p, ElementSettings es) {
        this.mySettings = es;
        this.myController = p;
    }

    public void setPoint(ControlPointEditor p) {
        this.myController = p;
    }

    public Integer getX() {
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return -1;
        }
        return (int)scalar.scaleX(this.myController.getSelected());
    }

    public Integer getY() {
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return -1;
        }
        return (int)scalar.scaleY(this.myController.getSelected());
    }

    public void paint(Graphics g) {
        PointProperties.PointConfigRenderer renderer;
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return;
        }
        PointProperties.PointConfigRenderer pointConfigRenderer = renderer = this.mySettings == null ? null : this.mySettings.getPointRenderer();
        if (renderer == null) {
            return;
        }
        renderer.paint(g, (List<Point2D>)this.myController.getChildren(), this.myController.getStateFlags(), scalar, null);
    }

    @Override
    public boolean contains(int x, int y, double distance) {
        return Point2D.Double.distance(this.getX().intValue(), this.getY().intValue(), x, y) <= distance;
    }

    public ControlPointEditor getController() {
        return this.myController;
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
    }

    public void itemAdded(Object invoker, Object controller, int index) {
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
    }

    public void structureChanged(Object invoker, Object controller) {
    }
}

