/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.compiled.CompiledPath;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.common.utils.Utils;
import org.rwshop.swing.animation.EditorElement;
import org.rwshop.swing.animation.ElementSettings;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.config.StrokeProperties;
import org.rwshop.swing.animation.timeline.TimelineMotionPath;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public class TimelineChannel
extends EditorListener
implements EditorElement {
    private ChannelEditor myController;
    private List<TimelineMotionPath> myMotionPaths;
    private ElementSettings mySettings;
    private PathProperties myPathProperties;

    public TimelineChannel(ChannelEditor channel, ElementSettings es) {
        this.mySettings = es;
        this.myController = channel;
        this.setPathProperties();
        this.setMotionPaths();
    }

    private void setMotionPaths() {
        this.myMotionPaths = new ArrayList<TimelineMotionPath>();
        for (MotionPathEditor c : this.myController.getChildren()) {
            TimelineMotionPath tlmp = new TimelineMotionPath(c, this.mySettings, this.myPathProperties);
            c.addConsumer((EditorListener)tlmp);
            this.myMotionPaths.add(tlmp);
        }
    }

    private void setPathProperties() {
        ChannelEditor editor = this.getController();
        if (editor == null) {
            return;
        }
        Color col = editor.getPrimaryColor();
        if (col == null) {
            return;
        }
        if (this.myPathProperties == null) {
            StrokeProperties stroke = new StrokeProperties(Float.valueOf(1.0f), null, null);
            this.myPathProperties = new PathProperties(stroke, col, Float.valueOf(1.0f));
        } else {
            this.myPathProperties.setColor(col);
        }
    }

    @Override
    public boolean contains(int x, int y, double distance) {
        long end;
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return false;
        }
        long stepLength = (long)scalar.unscaleX(distance);
        long start = (long)scalar.unscaleX((double)x - distance);
        CompiledPath cp = this.myController.getCompiledPath(start, end = (long)scalar.unscaleX((double)x + distance), stepLength);
        if (cp == null) {
            return false;
        }
        int i = x - (int)distance;
        while ((double)i <= (double)x + distance) {
            double cpY = this.getY(i, cp);
            if (!(cpY < 0.0) && Point2D.Double.distance(i, cpY, x, y) <= distance) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Double getY(long time) {
        long stepLength = 100L;
        long start = this.myController.getStart();
        long end = this.myController.getEnd();
        start = Utils.bound((long)(time - stepLength), (long)start, (long)end);
        end = Utils.bound((long)(time + stepLength), (long)start, (long)end);
        time = Utils.bound((long)time, (long)start, (long)(end - 1L));
        CompiledPath cp = this.myController.getCompiledPath(start, end, stepLength);
        if (cp == null) {
            return null;
        }
        return cp.estimatePosition(time);
    }

    private int getY(int x, CompiledPath cp) {
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return -1;
        }
        double lT = scalar.unscaleX((double)x);
        double lP = cp.estimatePosition((long)lT);
        if (lP == -1.0) {
            return -1;
        }
        return (int)scalar.scaleY(lP);
    }

    public void paint(Graphics g) {
        PathProperties.PathConfigRenderer renderer;
        CoordinateScalar scalar;
        CoordinateScalar coordinateScalar = scalar = this.mySettings == null ? null : this.mySettings.getScalar();
        if (scalar == null) {
            return;
        }
        PathProperties.PathConfigRenderer pathConfigRenderer = renderer = this.mySettings == null ? null : this.mySettings.getPathRenderer();
        if (renderer == null) {
            return;
        }
        if (this.myController.getChildren().isEmpty()) {
            return;
        }
        if (this.myController.hasFlag(EditState.VISIBLE)) {
            if (this.myController.hasFlag(EditState.SELECTED)) {
                this.drawMotionPaths(g);
            } else {
                renderer.paint(g, (List<Point2D>)this.myController.getInterpolatedPoints(), this.myController.getInheritedFlags(), scalar, this.myPathProperties);
            }
        } else if (this.myController.hasFlag(EditState.SELECTED)) {
            renderer.paint(g, (List<Point2D>)this.myController.getInterpolatedPoints(), scalar, "outline", null);
        }
    }

    public void drawMotionPaths(Graphics g) {
        TimelineMotionPath selected = this.getSelected();
        for (TimelineMotionPath tmp : this.myMotionPaths) {
            if (tmp == selected) continue;
            tmp.paint(g);
        }
        if (selected != null) {
            selected.paint(g);
        }
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
        this.setSelect(oldIndex, false);
        this.setSelect(newIndex, true);
    }

    private void setSelect(int i, boolean val) {
        if (i < 0 || i >= this.myMotionPaths.size()) {
            return;
        }
        TimelineMotionPath child = this.myMotionPaths.get(i);
        if (child != null && child.getController() != null) {
            MotionPathEditor ae = child.getController();
            ae.setState((Object)this, EditState.SELECTED, val, ae.getSharedHistory());
        }
    }

    public void itemAdded(Object invoker, Object controller, int index) {
        MotionPathEditor c = (MotionPathEditor)this.myController.getChildren().get(index);
        TimelineMotionPath tlmp = new TimelineMotionPath(c, this.mySettings, this.myPathProperties);
        c.addConsumer((EditorListener)tlmp);
        this.myMotionPaths.add(index, tlmp);
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
        this.myMotionPaths.remove(index);
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
        TimelineMotionPath m = this.myMotionPaths.remove(oldIndex);
        this.myMotionPaths.add(newIndex, m);
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
    }

    public TimelineMotionPath getSelected() {
        int i = this.myController.getSelectedIndex();
        if (i < 0 || i >= this.myMotionPaths.size()) {
            return null;
        }
        return this.myMotionPaths.get(i);
    }

    public ChannelEditor getController() {
        return this.myController;
    }

    public List<TimelineMotionPath> getMotionPaths() {
        return this.myMotionPaths;
    }

    public void structureChanged(Object invoker, Object controller) {
        this.setPathProperties();
    }
}

