/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.rwshop.swing.animation.EditorElement;
import org.rwshop.swing.animation.ElementSettings;
import org.rwshop.swing.animation.timeline.TimelineChannel;

public class TimelineAnimation
extends EditorListener
implements EditorElement {
    private AnimationEditor myAnimation;
    private List<TimelineChannel> myChannels;
    private ElementSettings mySettings;

    public TimelineAnimation(AnimationEditor a, ElementSettings es) {
        this.mySettings = es;
        this.myAnimation = a;
        this.setChannels();
    }

    private void setChannels() {
        this.myChannels = new ArrayList<TimelineChannel>();
        if (this.myAnimation == null) {
            return;
        }
        for (ChannelEditor c : this.myAnimation.getChildren()) {
            TimelineChannel tlc = new TimelineChannel(c, this.mySettings);
            c.addConsumer((EditorListener)tlc);
            this.myChannels.add(tlc);
        }
    }

    @Override
    public boolean contains(int x, int y, double distance) {
        for (TimelineChannel channel : this.myChannels) {
            if (!channel.contains(x, y, distance)) continue;
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        if (this.myChannels.isEmpty()) {
            return;
        }
        TimelineChannel selected = this.getSelected();
        for (TimelineChannel channel : this.myChannels) {
            if (channel == selected) continue;
            channel.paint(g);
        }
        if (selected != null) {
            selected.paint(g);
        }
    }

    public TimelineChannel getSelected() {
        int i = this.myAnimation.getSelectedIndex();
        if (i < 0 || i >= this.myChannels.size()) {
            return null;
        }
        return this.myChannels.get(i);
    }

    public List<TimelineChannel> getChannels() {
        return this.myChannels;
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
        this.setSelect(oldIndex, false);
        this.setSelect(newIndex, true);
    }

    private void setSelect(int i, boolean val) {
        if (i < 0 || i >= this.myChannels.size()) {
            return;
        }
        TimelineChannel child = this.myChannels.get(i);
        if (child != null && child.getController() != null) {
            ChannelEditor ae = child.getController();
            ae.setState((Object)this, EditState.SELECTED, val, ae.getSharedHistory());
        }
    }

    public void itemAdded(Object invoker, Object controller, int index) {
        ChannelEditor c = (ChannelEditor)this.myAnimation.getChildren().get(index);
        TimelineChannel tlc = new TimelineChannel(c, this.mySettings);
        c.addConsumer((EditorListener)tlc);
        this.myChannels.add(index, tlc);
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
        this.myChannels.remove(index);
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
        TimelineChannel channel = this.myChannels.remove(oldIndex);
        this.myChannels.add(newIndex, channel);
    }

    public AnimationEditor getController() {
        return this.myAnimation;
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
    }

    public void structureChanged(Object invoker, Object controller) {
    }
}

