/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.timeline;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.animation.utils.ChannelsParameter;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.animation.utils.PositionAdder;
import org.robokind.api.common.osgi.OSGiUtils;
import org.rwshop.swing.animation.ElementSettings;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.config.PointProperties;
import org.rwshop.swing.animation.config.PropertyReader;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.timeline.TimelineAnimation;
import org.rwshop.swing.animation.timeline.TimelineComponent;
import org.rwshop.swing.animation.timeline.listener.AnimationRepaintListener;
import org.rwshop.swing.animation.timeline.listener.TimelineContextMenuManager;
import org.rwshop.swing.animation.timeline.listener.TimelineKeyListener;
import org.rwshop.swing.animation.timeline.listener.TimelineMouseListener;
import org.rwshop.swing.animation.timeline.position.PositionSourceComponent;
import org.rwshop.swing.animation.timeline.range.TimeRangeComponent;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.FocusRequestor;
import org.rwshop.swing.common.ResizableGrid;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.ScalableComponent;
import org.rwshop.swing.common.utils.SettingsRepository;

public class AnimationTimelinePanel
extends ResizableGrid
implements ScalableComponent {
    private AnimationEditor myController;
    private TimelineAnimation myAnimationTimeline;
    private TimelineMouseListener myMotionPathMouseListener;
    private TimelineKeyListener myKeyListener;
    private AnimationRepaintListener myRepainter;
    private List<DrawableLayer> myLayers;
    private ElementSettings myElementSettings;
    private TimelineContextMenuManager myContextMenu;
    private TimeRangeComponent myTimeRangeComponent;
    private PositionSourceComponent myPositionSourceComponent;

    public AnimationTimelinePanel() {
        this.initComponents();
    }

    public void setScalar(CoordinateScalar scalar) {
        this.myScalar = scalar;
        PropertySet<PathProperties> pathProps = PropertyReader.getPathProperties(null, "default.channel");
        PropertySet<PointProperties> pointProps = PropertyReader.getPointProperties("controlpoint");
        PathProperties.PathConfigRenderer pathRenderer = new PathProperties.PathConfigRenderer(pathProps);
        PointProperties.PointConfigRenderer pointRenderer = new PointProperties.PointConfigRenderer(pointProps);
        this.myElementSettings = new ElementSettings(this.myScalar, pathRenderer, pointRenderer);
        this.myRepainter = new AnimationRepaintListener((JComponent)((Object)this));
        this.myContextMenu = new TimelineContextMenuManager(this, this.myScalar);
        this.myMotionPathMouseListener = new TimelineMouseListener(this.myScalar, this.myContextMenu);
        this.myKeyListener = new TimelineKeyListener((JPanel)((Object)this), this.myScalar);
        this.myTimeRangeComponent = new TimeRangeComponent();
        FocusRequestor.setFocusable((JPanel)((Object)this));
        this.addMouseListener(this.myMotionPathMouseListener);
        this.addMouseMotionListener(this.myMotionPathMouseListener);
        this.addMouseWheelListener(this.myMotionPathMouseListener);
        this.addKeyListener(this.myMotionPathMouseListener);
        this.addKeyListener(this.myKeyListener);
        this.myLayers = new ArrayList<DrawableLayer>();
        this.addTimelineComponent(this.myTimeRangeComponent);
        try {
            BundleContext context = OSGiUtils.getBundleContext(PositionAdder.class);
            this.myPositionSourceComponent = new PositionSourceComponent(context);
        }
        catch (Exception ex) {
            this.myPositionSourceComponent = null;
        }
        if (this.myPositionSourceComponent != null) {
            this.addTimelineComponent(this.myPositionSourceComponent);
            this.myMotionPathMouseListener.setPositionSource(this.myPositionSourceComponent.getPositionSource());
        }
    }

    private void addTimelineComponent(TimelineComponent comp) {
        this.myContextMenu.addMenuProvider(comp.getMenuProvider());
        comp.setScalar(this.myScalar);
        comp.setPanel((JPanel)((Object)this));
        this.myLayers.add(comp.getDrawLayer());
    }

    public void setController(AnimationEditor controller) {
        if (this.myAnimationTimeline != null) {
            this.myAnimationTimeline.cleanConsumer();
        }
        this.myRepainter.cleanConsumer();
        this.myController = controller;
        this.myAnimationTimeline = new TimelineAnimation(this.myController, this.myElementSettings);
        this.myMotionPathMouseListener.setAnimation(this.myController, this.myAnimationTimeline);
        this.myKeyListener.setController(this.myController);
        this.myContextMenu.setTimeline(this.myAnimationTimeline);
        this.myTimeRangeComponent.setEditor(controller);
        if (this.myPositionSourceComponent != null) {
            this.myPositionSourceComponent.setEditor(controller);
        }
        if (this.myController == null) {
            return;
        }
        this.myController.addConsumer((EditorListener)this.myAnimationTimeline);
        this.myController.recursiveAdd((EditorListener)this.myRepainter);
        this.resetSize();
        this.repaint();
    }

    public CoordinateScalar getScalar() {
        return this.myScalar;
    }

    public void resetSize() {
        this.setMinimumSize(new Dimension(this.getMinWidth(), this.getPreferredSize().height));
    }

    public int getMinWidth() {
        if (this.myController == null) {
            return 1;
        }
        long time = this.myController.getEnd();
        return (int)this.myScalar.scaleX((double)time) + 20;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myAnimationTimeline == null || this.myController == null) {
            return;
        }
        if (SettingsRepository.getAntiAliasing()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.myAnimationTimeline.paint(g);
        for (DrawableLayer layer : this.myLayers) {
            layer.paint(g);
        }
        ChannelEditor channel = (ChannelEditor)this.myController.getSelected();
        if (channel != null) {
            ChannelsParameterSource paramSource = AnimationUtils.getChannelsParameterSource();
            if (paramSource == null) {
                return;
            }
            int id = channel.getId();
            Double def = null;
            for (ChannelsParameter chanParam : paramSource.getChannelParameters()) {
                if (chanParam.getChannelID() != id) continue;
                def = chanParam.getDefaultPosition().getValue();
                break;
            }
            if (def == null) {
                return;
            }
            int y = (int)this.myScalar.scaleY(def.doubleValue());
            g.setColor(channel.getPrimaryColor());
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 17, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
    }

    public int getMinHeight() {
        return 0;
    }

    public void rescale(int minWidth, int minHeight) {
        int minAnim = this.getMinWidth();
        int minPnl = this.getMinimumSize().width;
        int size = Math.max(minAnim, minPnl);
        size = Math.max(size, minWidth);
        this.setPreferredSize(new Dimension(size, this.getPreferredSize().height));
        this.revalidate();
        this.repaint();
    }

    public void setFocusPosition(Integer x, Integer y) {
    }
}

