/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.motionpath;

import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.rwshop.swing.animation.table.motionpath.MotionPathTableModel;

public class MotionPathTablePathListener
extends EditorListener {
    private JTable myTable;
    private MotionPathTableModel myTableModel;

    public MotionPathTablePathListener(MotionPathTableModel m) {
        this.myTableModel = m;
    }

    public void setTable(JTable table) {
        this.myTable = table;
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
        if (this.myTable == null) {
            return;
        }
        this.myTable.getSelectionModel().setSelectionInterval(newIndex, newIndex);
        final int i = newIndex;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MotionPathTablePathListener.this.myTable.scrollRectToVisible(MotionPathTablePathListener.this.myTable.getCellRect(i, MotionPathTablePathListener.this.myTable.getColumnCount(), true));
            }
        });
    }

    public void itemAdded(Object invoker, Object controller, int index) {
        this.myTableModel.fireTableRowsInserted(index, index);
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
        this.myTableModel.fireTableRowsDeleted(index, index);
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
        int min = oldIndex > newIndex ? newIndex : oldIndex;
        int max = oldIndex < newIndex ? newIndex : oldIndex;
        this.myTableModel.fireTableRowsUpdated(min, max);
    }

    public void structureChanged(Object invoker, Object controller) {
        this.myTableModel.fireTableDataChanged();
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
    }
}

